package com.bizunited.nebula.task.local.service.strategy;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.task.service.strategy.DynamicTaskParamValueConverter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

/**
 * 该转换器用来进行业务对象的json数组信息转换</br>
 * TODO 该转换器还没有充分测试过
 * @author yinwenjie
 */
@Component("_DynamicTaskParamValueJsonArrayConverter")
public class DynamicTaskParamValueJsonArrayConverter implements DynamicTaskParamValueConverter {

  @Override
  public boolean canConverter(int index, Type paramType) {
    /*
     * 必须实现了List接口或者Set接口，才返回true
     * */
    if(paramType instanceof Set || paramType instanceof List) {
      return true;
    }
    
    return false;
  }

  @Override
  public String serialize(int index, Type paramType, Object value) {
    String stringValue = JSONArray.toJSONString(value);
    return stringValue;
  } 

  @Override
  public Object deserialize(int index, Type paramType, String value) {
    GenericArrayType paramGenericType = (GenericArrayType)paramType;
    Type genericType = paramGenericType.getGenericComponentType();
    JSONArray jsonArray = JSONArray.parseArray(value);
    
    // 如果是Set，则使用LinkedHashSet
    if(paramType instanceof Set) {
      Set<?> results = Sets.newLinkedHashSet();
      for (int i = 0 ; i < jsonArray.size() ; i++) {
        JSONObject jsonObject = (JSONObject)jsonArray.get(i);
        results.add(jsonObject.toJavaObject(genericType));
      }
      return results;
    } 
    // 如果是List，则使用ArrayList
    else if(paramType instanceof List) {
      List<?> results = Lists.newArrayList();
      for (int i = 0 ; i < jsonArray.size() ; i++) {
        JSONObject jsonObject = (JSONObject)jsonArray.get(i);
        results.add(jsonObject.toJavaObject(genericType));
      }
      return results;
    }
    return null;
  }
}