package com.bizunited.nebula.task.vo;

import java.util.Date;
import java.util.List;

import javax.persistence.Transient;

import org.springframework.format.annotation.DateTimeFormat;

import com.bizunited.nebula.common.vo.UuidOpVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("nebula周期性或一次性动态任务，结合多应用多租户的工作场景，那么动态任务都是每一个应用appCode都有一个动态任务")
public class DynamicTaskSchedulerVo extends UuidOpVo {
  private static final long serialVersionUID = 4250320260458703136L;

  @Transient
  @ApiModelProperty("动态任务信息操作的预授权标记")
  private String prefix;
  
  @ApiModelProperty("任务唯一编号（只能由英文、数字、下杠构成）")
  private String taskCode;
  
  @ApiModelProperty("任务中文说明")
  private String taskDesc;
  /**
   * 多应用编码（在一个数据库中，有多个不同的appCode的情况不多，但还是需要支持）
   */
  @ApiModelProperty("多应用编码（在一个数据库中，有多个不同的appCode的情况不多，但还是需要支持）")
  private String appCode;
  /**
   * 由于多个微服务中心可能共享一个数据库
   * 那么就存在A服务更新定时任务时，将B服务中心配置的定时任务误操作。
   * 为了避免这个情况，这里可以有扫描程序设定服务名（必须有）
   */
  @ApiModelProperty("由于多个微服务中心可能共享一个数据库，那么就存在A服务更新定时任务时，将B服务中心配置的定时任务误操作。为了避免这个情况，这里可以有扫描程序设定服务名（必须有）")
  private String applicationName = "default";
  /**
   * 动态任务内容的执行方式:</br>
   * 1：groovy脚本执行器</br>
   * 2：基于注解的Java method</br>
   * 3：全动态调用任务——一个在IOC容器中的一个普通public方法，其可以让任务基本信息作为任务方法的入参
   */
  @ApiModelProperty("定时器任务内容的执行方式：1：groovy脚本执行器；2：基于注解的Java method；3、全动态调用任务")
  private Integer invokeType;

  @ApiModelProperty("任务类型：1、一次性执行；2：周期性执行")
  private Integer taskType = 2;

  @ApiModelProperty("任务状态：0：无效任务；1、有效任务")
  private Integer tstatus = 0;

  @ApiModelProperty("工作状态：0：要求运行， 1：要求停止，2：已运行；3、已停止；4、要求重启")
  private Integer workingStatus = 0;

  @ApiModelProperty("一次性任务的执行时间点")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date executePoint;

  @ApiModelProperty("周期性任务执行表单式，满足corn表达式")
  private String executeExpression;

  @ApiModelProperty("周期性表单时的中文解析")
  private String expressionDesc;

  @ApiModelProperty("执行的groovy脚本名（唯一的脚本名），可以是空字符串")
  private String scriptName;

  @ApiModelProperty("执行的java method时的短方法名，只包括方法名，不包括类名")
  private String invokeMethod;

  @ApiModelProperty("执行基于注解的java method时的对应的spring bean信息")
  private String invokeBeanName;

  @ApiModelProperty("任务有效期")
  private Date validityTime;
  
  @ApiModelProperty("可能关联的动态任务的参数信息")
  private List<DynamicTaskParamVo> params;
  
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getTaskDesc() {
    return taskDesc;
  }
  public void setTaskDesc(String taskDesc) {
    this.taskDesc = taskDesc;
  }
  public String getAppCode() {
    return appCode;
  }
  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
  public String getApplicationName() {
    return applicationName;
  }
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }
  public Integer getInvokeType() {
    return invokeType;
  }
  public void setInvokeType(Integer invokeType) {
    this.invokeType = invokeType;
  }
  public Integer getTaskType() {
    return taskType;
  }
  public void setTaskType(Integer taskType) {
    this.taskType = taskType;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Integer getWorkingStatus() {
    return workingStatus;
  }
  public void setWorkingStatus(Integer workingStatus) {
    this.workingStatus = workingStatus;
  }
  public Date getExecutePoint() {
    return executePoint;
  }
  public void setExecutePoint(Date executePoint) {
    this.executePoint = executePoint;
  }
  public String getExecuteExpression() {
    return executeExpression;
  }
  public void setExecuteExpression(String executeExpression) {
    this.executeExpression = executeExpression;
  }
  public String getExpressionDesc() {
    return expressionDesc;
  }
  public void setExpressionDesc(String expressionDesc) {
    this.expressionDesc = expressionDesc;
  }
  public String getScriptName() {
    return scriptName;
  }
  public void setScriptName(String scriptName) {
    this.scriptName = scriptName;
  }
  public String getInvokeMethod() {
    return invokeMethod;
  }
  public void setInvokeMethod(String invokeMethod) {
    this.invokeMethod = invokeMethod;
  }
  public String getInvokeBeanName() {
    return invokeBeanName;
  }
  public void setInvokeBeanName(String invokeBeanName) {
    this.invokeBeanName = invokeBeanName;
  }
  public Date getValidityTime() {
    return validityTime;
  }
  public void setValidityTime(Date validityTime) {
    this.validityTime = validityTime;
  }
  public String getPrefix() {
    return prefix;
  }
  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }
  public List<DynamicTaskParamVo> getParams() {
    return params;
  }
  public void setParams(List<DynamicTaskParamVo> params) {
    this.params = params;
  }
}
