package com.bizunited.nebula.task.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 动态任务注解，通过这个注解程序员可以将一个托管给Spring容器的某个接口中的方法，加入到业务构建平台的定时器执行模块</br>
 * 该注解可以标识在某个方法上，标识这个方法需要周期性或者一次性执行（在指定的时间点后）</p>
 * 
 * 请注意使用该注解标识的方法，不支持返回值。且该方法要么只有一个入参InvokeProxyContext，要么没有入参。
 * 如果被注解标识的方法不满足这样的定义要求，则在应用程序启动时会报错，并终止启动
 * @author yinwenjie
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = { java.lang.annotation.ElementType.METHOD })
@Documented
public @interface DynamicTaskService {
  
  /**
   * 该表达式标识是否只执行一次，默认为false，既是需要周期性执行
   */
  boolean onlyOnce() default false;
  
  /**
   * 该属性在onlyOnce属性标识为true的时候，指定一个固定的一次性执行的时间点。</br>
   * 该属性可精确到秒，格式为yyyy-MM-dd HH:mm:ss，如果不满足这个时间格式的要求，则在应用程序启动时会报错，并终止启动
   */
  String executePoint() default "";
  
  /**
   * 该属性无论onlyOnce属性值如何，都可以填写。是一个corn表达式。<br>
   * 如果corn表达式不符合要求，则在应用程序启动时会报错，并终止启动
   */
  String cornExpression() default "";
  /**
   * 必须说明当前定时器的业务意义
   * @return
   */
  String taskDesc();
  
  /**
   * 可以通过这个属性，设定当前定时任务（无论是周期性任务还是一次性任务）的失效时间</br>
   * 失效时间可精确到描述，格式为yyyy-MM-dd HH:mm:ss
   * @return
   */
  String validityPoint() default "";
}