package com.bizunited.nebula.task.service.strategy;

import com.bizunited.nebula.task.vo.DynamicTaskOperatorVo;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;

/**
 * 动态任务模块所使用的操作者转换记录装置。这主要是因为当动态任务在独立线程运行时，很多情况下，需要明确这个任务的操作者是谁，
 * 以便动态任务在需要取得用户信息、调用外部feign接口时，能够保持用户信息状态。</br>
 * 所以在动态任务创建是，需要根据DynamicTaskOperatorConverter接口的要求，明确当前的操作者信息，并进行记录
 * @author yinwenjie
 *
 */
public interface DynamicTaskOperatorConverter {
  /**
   * 如果存在多个操作者转换器时，sort返回值越低的转换器越先运行
   */
  public int sort();
  
  /**
   * 该方法用于在动态任务创建/修改时，为这个任务将来的运行创建一个操作者信息
   * @param task 当前正在创建/修改的动态任务信息
   * @return 如果创建操作者成功，则返回这个操作者对象，否则返回null；
   * @exception 如果抛出异常，那么涉及的动态任务创建或者修改过程将会终止
   */
  public DynamicTaskOperatorVo buildDynamicTaskOperator(DynamicTaskSchedulerVo task);
}
