package com.bizunited.nebula.task.service.strategy;

import java.lang.reflect.Type;

/**
 * 动态任务参数值转换器</br>
 * TODO 该转换器还很基本，还没有加入转换目标方法的类型、注解等这些信息，后续要进行完善
 * @author yinwenjie
 */
public interface DynamicTaskParamValueConverter {
  
  /**
   * 是否为默认的参数值转换器。</br>
   * 如果为默认的制转换器，当所有参数值转换都失效的时候，则会使用这个默认的转换器。</br>
   * 一般的值转化器实现中，该方法都返回false。<br>
   * 注意，如果isDefault()方法返回的是true，则canConverter方法一定需要返回false
   * @return
   */
  public default boolean isDefault() {
    return false;
  }
  /**
   * 在置换转器能够真正被运行起来时，该方法会提前运行，已确认当前转换器的具体实现，是否能胜任指定方法索引位、指定任务类型的序列化或反序列化要求
   * @param index 参数在动态任务方法中的索引位置
   * @param paramType 参数值的类型
   * @return 如果该转换器能匹配，则返回true；其它情况返回false
   */
  public boolean canConverter(int index , Type paramType);
  /**
   * 该方法在动态任务配置信息存储时，将一个可以真实的调用参数值进行序列化，以便存储到诸如数据库这样的中间件中，做持久化存储。
   * @param index 参数在动态任务方法中的索引位置
   * @param paramType 参数值的类型
   * @param value 参数值
   * @return 经过序列化后，能被持久存储的值信息
   */
  public String serialize(int index , Type paramType , Object value);
  
  /**
   * 该方法在动态任务真实被调用时，将保存在持久化层的经过序列化的数据，按照指定的参数类型进行参数对象实例化。以便动态方法运行时参数值真够正确的被传入
   * @param index 参数在动态任务方法中的索引位置 
   * @param paramType 参数值的类型
   * @param value 反序列化前的值
   * @return 经过反序列化后，能够真正被运行的参数
   */
  public Object deserialize(int index , Type paramType , String value);
}