package com.bizunited.nebula.task.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.bizunited.nebula.task.dto.DynamicTaskSchedulerLogDto;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerLogVo;

/**
 * DynamicTaskSchedulerLogEntity业务模型的服务层接口定义
 * @author yinwenjie
 */
public interface DynamicTaskSchedulerLogVoService { 
  /**
   * 创建一个新的DynamicTaskSchedulerVo模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  public DynamicTaskSchedulerLogVo create(DynamicTaskSchedulerLogVo dynamicTaskSchedulerLog);
  /**
   * 更新DynamicTaskSchedulerVo模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  public DynamicTaskSchedulerLogVo createOrModify(DynamicTaskSchedulerLogVo dynamicTaskSchedulerLog);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);
  /**
   * 按照指定的动态任务数据库编码，真删除其下所有的日志信息
   */
  public void deleteByDynamicTaskId(String dynamicTaskId);
  /**
   * -该方法用于按照分页标准，对动态任务日志列表进行查询，并按照开始执行时间进行倒序排列
   * @param pageable 分页信息
   * @param conditions 查询条件
   */
  public Page<DynamicTaskSchedulerLogVo> findByConditions(Pageable pageable, DynamicTaskSchedulerLogDto conditions);
  /**
   * 按照DynamicTaskSchedulerVo的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  public DynamicTaskSchedulerLogVo findById(String id);
}