package com.bizunited.nebula.task.service.security;

import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;

/**
 * 当独立的定时器任务开始工作时，是一个独立的线程（且这个线程不是web请求的线程）</br>
 * 这就造成一个困扰：当前定时器任务的线程是不存在spring security身份上下文信息的。</p>
 * 
 * 为了保证让这个线程具备身份上下文，定时任务需要指定一个当前接口的实现类。
 * 在该类中，完成为当前定时器任务设定spring security身份上下文信息的工作
 * 
 * @author yinwenjie
 *
 */
public interface IndependencySecurity {
  /**
   * 在一个具体的独立线程任务被正式执行前，该方法会被触发，以便技术人员能够为本次任务执行设定上下文身份会话信息
   * @param taskCode 当前要执行的定时器任务的任务业务编号
   * @param appCode 当前执行该任务的顶级租户信息
   * @param applicationName 当前执行该任务的应用名信息（可参见DynamicTaskProperties属性对象中的设定）
   */
  public void independency(String taskCode , String appCode , String applicationName);
  
  /**
   * TODO 注释未写
   * @param currentTask
   * @param taskCode
   * @param appCode
   * @param applicationName
   */
  public default void independency(DynamicTaskSchedulerVo currentTask , String taskCode , String appCode , String applicationName) {
    independency(taskCode, appCode, applicationName);
  }
}
