package com.bizunited.nebula.task.service.strategy;

import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;

/**
 * @author ning.zhang
 * @description 定时任务分片请求策略,此策略将用于对开启了多节点任务执行功能时,将主节点的定时任务执行分发到具体的应用节点
 *              执行,此策略的实现类只能有一个,如果定时任务模块提供的默认实现无法满足项目分发的需求,可自行实现此策略接口,
 *              覆盖掉默认实现即可
 * @date 2023/09/28
 */
public interface DynamicTaskShardingRequestStrategy {

  /**
   * 请求当前应用分片执行节点,执行定时任务
   *
   * @param currentTask 需执行的定时任务信息
   */
  void doRequest(DynamicTaskSchedulerVo currentTask);
}
