package com.bizunited.nebula.task.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 动态任务操作者（详细使用方式参见DynamicTaskOperatorConverter接口）
 * @author yinwenjie
 */
@ApiModel("动态任务操作者（详细使用方式参见DynamicTaskOperatorConverter接口）")
public class DynamicTaskOperatorVo {
  /**
   * 任务唯一编号（只能由英文、数字、下杠构成）
   */
  @ApiModelProperty("动态定时任务唯一编号（只能由英文、数字、下杠构成）")
  private String taskCode;
  /**
   * 任务操作者的顶级租户信息
   */
  @ApiModelProperty("任务操作者的顶级租户信息")
  private String appCode;
  /**
   * 由于多个微服务中心可能共享一个数据库
   * 那么就存在A服务更新定时任务时，将B服务中心配置的定时任务误操作。
   * 为了避免这个情况，这里可以有扫描程序设定服务名（必须有）
   */
  @ApiModelProperty("扫描程序设定服务名")
  private String applicationName = "default";
  /**
   * 任务操作者的二级租户信息
   */
  @ApiModelProperty("任务操作者的二级租户信息")
  private String tenantCode;
  /**
   * 操作者账号信息（需要保证在特定租户下，账号信息是唯一的）
   */
  @ApiModelProperty("操作者账号信息（需要保证在特定租户下，账号信息是唯一的）")
  private String account;
  /**
   * 操作者的角色信息（必须携带）
   */
  @ApiModelProperty("操作者的角色信息（必须携带）")
  private String roles[];
  
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getApplicationName() {
    return applicationName;
  }
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }
  public String getAppCode() {
    return appCode;
  }
  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
  public String getTenantCode() {
    return tenantCode;
  }
  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
  public String getAccount() {
    return account;
  }
  public void setAccount(String account) {
    this.account = account;
  }
  public String[] getRoles() {
    return roles;
  }
  public void setRoles(String[] roles) {
    this.roles = roles;
  }
}
