package com.bizunited.nebula.task.vo;

import com.bizunited.nebula.common.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "DynamicTaskParamVo", description = "周期性动态任务可能的传递的参数，支持普通类型或者对象参数转换")
public class DynamicTaskParamVo extends UuidVo {
  /**
   * 
   */
  private static final long serialVersionUID = -7525607821759678955L;
  
  @ApiModelProperty(name="paramType" , value = "参数类型，支持基本类型或者可序列化（json）的对象")
  private Class<?> paramType;
  
  @ApiModelProperty(name="paramIndex" , value = "参数索引号，索引号从0开始，当方法参数无法自动匹配的时候，才会使用索引号进行匹配")
  private Integer paramIndex;
  
  @ApiModelProperty(name="paramValue" , value = "参数值,如果是序列化的对象信息，请注意参数长度")
  private Object paramValue;

  public DynamicTaskParamVo() {
    
  }

  public DynamicTaskParamVo(Class<?> paramType, Integer index, Object paramValue) {
    this.paramType = paramType;
    this.paramIndex = index;
    this.paramValue = paramValue;
  }

  public Class<?> getParamType() {
    return paramType;
  }

  public void setParamType(Class<?> paramType) {
    this.paramType = paramType;
  }

  public Integer getParamIndex() {
    return paramIndex;
  }

  public void setParamIndex(Integer paramIndex) {
    this.paramIndex = paramIndex;
  }

  public Object getParamValue() {
    return paramValue;
  }

  public void setParamValue(Object paramValue) {
    this.paramValue = paramValue;
  }
  
}
