package com.bizunited.nebula.task.vo;

import com.bizunited.nebula.common.vo.UuidVo;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

/**
 * 周期性或一次性动态任务的执行日志
 * @author yinwenjie
 */
@ApiModel(value = "DynamicTaskSchedulerLogVo", description = "周期性或一次性动态任务的执行日志")
public class DynamicTaskSchedulerLogVo extends UuidVo {
  /**
   * 
   */
  private static final long serialVersionUID = 7899433204549913269L;
  
  @ApiModelProperty(name="dynamicTaskId" , value="对应的动态任务技术编号", required=true)
  private String dynamicTaskId;
  /**
   * 对应的动态日志
   */
  @ApiModelProperty(name="dynamicTaskScheduler" , value="对应的动态任务业务编号", required=true)
  private String taskCode;
  /**
   * 任务中文说明
   */
  @ApiModelProperty("任务中文说明")
  private String taskDesc;
  /**
   * 由于多个微服务中心可能共享一个数据库
   * 那么就存在A服务更新定时任务时，将B服务中心配置的定时任务误操作。
   * 为了避免这个情况，这里可以有扫描程序设定服务名（必须有）
   */
  @ApiModelProperty(name="applicationName" , value="应用程序名", required=true)
  private String applicationName = "default";
  /**
   * 多应用编码（在一个数据库中，有多个不同的appCode的情况不多，但还是需要支持）
   */
  @ApiModelProperty(name="appCode" , value="多应用编码（在一个数据库中，有多个不同的appCode的情况不多，但还是需要支持）", required=true)
  private String appCode;
  /**
   * 执行开始时间
   */
  @ApiModelProperty(name="startTime" , value="执行开始时间", required=true)
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;
  /**
   * 执行结束时间
   */
  @ApiModelProperty(name="endTime" , value="执行结束时间", required=true)
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
  /**
   * 执行是否成功
   */
  @ApiModelProperty(name="success" , value="执行是否成功", required=true)
  private Boolean success;
  /**
   * 可能的错误日志(详细日志)
   */
  @ApiModelProperty(name="errorContents" , value="可能的错误日志", required=false)
  private String errorContents;
  /**
   * 可能的错误日志(错误概要)
   */
  @ApiModelProperty(name="errorSummary" , value="可能的错误日志", required=false)
  private String errorSummary;
  /**
   * 调度状态(10: 执行中, 20: 执行成功,30: 执行失败)
   */
  @ApiModelProperty(name="state" , value="调度状态", required=false)
  private String state;
  
  public String getDynamicTaskId() {
    return dynamicTaskId;
  }
  public void setDynamicTaskId(String dynamicTaskId) {
    this.dynamicTaskId = dynamicTaskId;
  }
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getApplicationName() {
    return applicationName;
  }
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }
  public String getAppCode() {
    return appCode;
  }
  public void setAppCode(String appCode) {
    this.appCode = appCode;
  }
  public Date getStartTime() {
    return startTime;
  }
  public void setStartTime(Date startTime) {
    this.startTime = startTime;
  }
  public Date getEndTime() {
    return endTime;
  }
  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }
  public Boolean getSuccess() {
    return success;
  }
  public void setSuccess(Boolean success) {
    this.success = success;
  }
  public String getErrorContents() {
    return errorContents;
  }
  public void setErrorContents(String errorContents) {
    this.errorContents = errorContents;
  }
  public String getTaskDesc() {
    return taskDesc;
  }
  public void setTaskDesc(String taskDesc) {
    this.taskDesc = taskDesc;
  }
  public String getErrorSummary() {
    return errorSummary;
  }
  public void setErrorSummary(String errorSummary) {
    this.errorSummary = errorSummary;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }
}