/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.config;

import com.bizunited.nebula.common.service.async.AsyncTask;
import com.bizunited.nebula.common.service.async.AsyncTaskRunnable;
import com.bizunited.nebula.common.service.async.AsyncTaskThreadPoolExecutor;
import com.bizunited.nebula.common.service.async.AsyncThreadHandler;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class AsyncTaskConfig
implements CommandLineRunner {
    private AtomicInteger threadPoolCount = new AtomicInteger(1);
    @Autowired
    private ApplicationContext applicationContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTaskConfig.class);

    @Bean(value={"_asyncTaskExecutor"})
    public ExecutorService getThreadPoolExecutor() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (availableProcessors < 8) {
            availableProcessors = 8;
        }
        return new AsyncTaskThreadPoolExecutor(availableProcessors, availableProcessors, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r, "nebula_sync_task_thread_" + AsyncTaskConfig.this.threadPoolCount.getAndIncrement());
                return newThread;
            }
        });
    }

    @Bean(value={"_asyncTask"})
    @Scope(value="prototype")
    public AsyncTask getAsyncTask(AsyncTaskRunnable<?> asyncTaskRunnable, List<AsyncThreadHandler> asyncThreadHandlers) {
        return new AsyncTask(asyncTaskRunnable, asyncThreadHandlers);
    }

    public void run(String ... args) throws Exception {
        String[] beanNames = this.applicationContext.getBeanNamesForType(AsyncThreadHandler.class);
        if (beanNames != null && beanNames.length > 0) {
            for (String beanName : beanNames) {
                if (this.applicationContext.isPrototype(beanName)) continue;
                LOGGER.error("\u542f\u52a8\u5e94\u7528\u7a0b\u5e8f\u65f6\u53d1\u73b0bean name\u4e3a\uff1a{} \u7684AsyncThreadHandler\u63a5\u53e3\u5b9e\u73b0\uff0c\u5176\u6ce8\u518c\u5230IOC\u5bb9\u5668\u65f6\u5bf9\u8c61\u4f5c\u7528\u8303\u56f4\u5e76\u975e\u201cprototype\u201d\uff0c\u8bf7\u68c0\u67e5\u5e76\u66f4\u6b63\u540e\u518d\u542f\u52a8\u5e94\u7528\u7a0b\u5e8f\uff01", (Object)beanName);
                System.exit(500);
            }
        } else {
            LOGGER.warn("\u542f\u52a8\u5e94\u7528\u7a0b\u5e8f\u65f6\u53d1\u73b0\u7cfb\u7edf\u4e2d\u6ca1\u6709\u4efb\u4f55\u5173\u4e8eAsyncThreadHandler\u63a5\u53e3\u7684\u5177\u4f53\u5b9e\u73b0\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f!");
        }
    }
}

