/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.config;

import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration
public class CorsFilterConfig {
    private static final Long MAX_AGE = 1728000L;
    private static final String TENANT_HEAD_NAME = "tenant";
    private static final String DOMAIN_SOURCE_NAME = "domain_source";
    private static final String JWT_NAME = "jwt";

    @Bean
    public CorsWebFilter getCorsFilter() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowedOriginPatterns((List)Lists.newArrayList((Object[])new String[]{"*"}));
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addExposedHeader(TENANT_HEAD_NAME);
        config.addExposedHeader(DOMAIN_SOURCE_NAME);
        config.addExposedHeader(JWT_NAME);
        config.setMaxAge(MAX_AGE);
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(new PathPatternParser());
        source.registerCorsConfiguration("/**", config);
        return new CorsWebFilter((CorsConfigurationSource)source);
    }
}

