/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.config;

import com.bizunited.nebula.common.config.RedisCustomProperties;
import com.bizunited.nebula.common.service.redis.DefaultRedisMutexServiceImpl;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class RedissonCustomConfig {
    @Autowired
    private RedisCustomProperties redisCustomProperties;
    private static final String REDIS_PREFIX = "redis://";

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public RedissonClient getRedissonClient() {
        SingleServerConfig serverConfig;
        Config config = new Config();
        RedissonClient redissonClient = null;
        if (StringUtils.equals((CharSequence)this.redisCustomProperties.getModel(), (CharSequence)"single")) {
            serverConfig = ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(REDIS_PREFIX + this.redisCustomProperties.getAddress()[0]).setDatabase(this.redisCustomProperties.getDatabase()).setTimeout(this.redisCustomProperties.getTimeout())).setRetryAttempts(this.redisCustomProperties.getRetryAttempts())).setRetryInterval(this.redisCustomProperties.getRetryInterval())).setPingConnectionInterval(this.redisCustomProperties.getPingConnectionInterval())).setConnectionPoolSize(this.redisCustomProperties.getConnectionPoolSize()).setConnectionMinimumIdleSize(this.redisCustomProperties.getConnectionMinimumIdleSize());
            if (!StringUtils.isBlank((CharSequence)this.redisCustomProperties.getPassword())) {
                serverConfig.setPassword(this.redisCustomProperties.getPassword());
            }
            redissonClient = Redisson.create((Config)config);
        }
        if (StringUtils.equals((CharSequence)this.redisCustomProperties.getModel(), (CharSequence)"cluster")) {
            serverConfig = (ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().addNodeAddress(this.redisCustomProperties.getAddress()).setTimeout(this.redisCustomProperties.getTimeout())).setRetryAttempts(this.redisCustomProperties.getRetryAttempts())).setRetryInterval(this.redisCustomProperties.getRetryInterval())).setPingConnectionInterval(this.redisCustomProperties.getPingConnectionInterval())).setMasterConnectionPoolSize(this.redisCustomProperties.getConnectionPoolSize())).setSlaveConnectionPoolSize(this.redisCustomProperties.getConnectionPoolSize())).setMasterConnectionMinimumIdleSize(this.redisCustomProperties.getConnectionMinimumIdleSize())).setSlaveConnectionMinimumIdleSize(this.redisCustomProperties.getConnectionMinimumIdleSize());
            if (!StringUtils.isBlank((CharSequence)this.redisCustomProperties.getPassword())) {
                serverConfig.setPassword(this.redisCustomProperties.getPassword());
            }
            redissonClient = Redisson.create((Config)config);
        }
        if (StringUtils.equals((CharSequence)this.redisCustomProperties.getModel(), (CharSequence)"sentinel")) {
            serverConfig = (SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().addSentinelAddress(this.redisCustomProperties.getAddress()).setDatabase(this.redisCustomProperties.getDatabase()).setTimeout(this.redisCustomProperties.getTimeout())).setRetryAttempts(this.redisCustomProperties.getRetryAttempts())).setRetryInterval(this.redisCustomProperties.getRetryInterval())).setPingConnectionInterval(this.redisCustomProperties.getPingConnectionInterval())).setMasterConnectionPoolSize(this.redisCustomProperties.getConnectionPoolSize())).setSlaveConnectionPoolSize(this.redisCustomProperties.getConnectionMinimumIdleSize());
            if (!StringUtils.isBlank((CharSequence)this.redisCustomProperties.getPassword())) {
                serverConfig.setPassword(this.redisCustomProperties.getPassword());
            }
            redissonClient = Redisson.create((Config)config);
        }
        return redissonClient;
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(name={"redisMutexService"})
    public RedisMutexService getRedisMutexService() {
        return new DefaultRedisMutexServiceImpl();
    }
}

