/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.interceptor;

import com.bizunited.nebula.common.interceptor.NebulaFeignRequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class HeaderContextRequestInterceptor
implements NebulaFeignRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderContextRequestInterceptor.class);

    @Override
    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes;
        if (this.existed(requestTemplate)) {
            LOGGER.debug("<WEB\u5bb9\u5668\u8bf7\u6c42\u4e4bRequestContextHolder\u4e0a\u4e0b\u6587>\u62e6\u622a\u5668\u68c0\u67e5\u5230\u5df2\u7ecf\u5b58\u5728\u4f1a\u8bdd\u4fe1\u606f!!");
            return;
        }
        try {
            attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        }
        catch (IllegalStateException e) {
            LOGGER.debug("\u4e0d\u5b58\u5728we request \u4e0a\u4e0b\u6587\uff0c\u672c\u7b56\u7565\u5668\uff08RequestContextTransmitStrategyImpl\uff09\u5931\u6548!!");
            return;
        }
        catch (RuntimeException e) {
            LOGGER.warn("\u672a\u53d6\u5f97\u5f53\u524d\u8bf7\u6c42\u4e0a\u4e0b\u6587\uff0c\u8fd9\u5f88\u53ef\u80fd\u662f\u56e0\u4e3a\u4f7f\u7528\u4e86\u72ec\u7acb\u7ebf\u7a0b\uff08\u7ebf\u7a0b\u6c60\uff09\u8fdb\u884c\u7194\u65ad\u5668\u63a7\u5236\u9020\u6210\u7684\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e!!", (Throwable)e);
            return;
        }
        HttpServletRequest request = attributes.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String values = request.getHeader(name);
                if (name.equals("content-length")) continue;
                requestTemplate.header(name, new String[]{values});
            }
        }
    }

    public int getOrder() {
        return 1;
    }
}

