/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service;

import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CodeGeneratorService")
public class CodeGeneratorService {
    @Autowired
    private RedisMutexService redisMutexService;

    public String generate(String redisIndexKey, String prefix, String suffix, long min, int indexLength) {
        return this.generate(redisIndexKey, prefix, suffix, min, indexLength, 0L, null);
    }

    public String generate(String redisIndexKey, String prefix, String suffix, long min, int indexLength, long expire, TimeUnit unit) {
        Validate.notBlank((CharSequence)redisIndexKey, (String)"redis\u7d22\u5f15\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((indexLength > 0 ? 1 : 0) != 0, (String)"\u7d22\u5f15\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        if (expire > 0L) {
            Validate.notNull((Object)((Object)unit), (String)"\u8fc7\u671f\u65f6\u95f4\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        String code = expire > 0L ? this.redisMutexService.getAndIncrement(redisIndexKey, min, indexLength, expire, unit) : this.redisMutexService.getAndIncrement(redisIndexKey, min, indexLength);
        if (prefix != null) {
            code = StringUtils.join((Object[])new String[]{prefix, code});
        }
        if (suffix != null) {
            code = StringUtils.join((Object[])new String[]{code, suffix});
        }
        return code;
    }
}

