/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service.analysis;

import com.bizunited.nebula.common.dto.AnalysisFieldDto;
import com.bizunited.nebula.common.register.ControllerReturnFieldAnalysisRegister;
import com.bizunited.nebula.common.service.ControllerAnalysisService;
import com.bizunited.nebula.common.vo.AnalysisFieldInfoVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Service
public class ControllerAnalysisServiceImpl
implements ControllerAnalysisService {
    @Autowired(required=false)
    private List<ControllerReturnFieldAnalysisRegister> fieldAnalysisRegisters;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;

    @Override
    public List<AnalysisFieldInfoVo> analyzeReturnFiled(AnalysisFieldDto dto) {
        List<Object> resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(this.fieldAnalysisRegisters) || StringUtils.isBlank((CharSequence)dto.getApiUrl())) {
            return resultList;
        }
        String requestMapping = StringUtils.isBlank((CharSequence)dto.getRequestMethod()) ? "GET" : dto.getRequestMethod();
        HandlerMethod handlerMethod = this.getHandlerMethod(dto.getApiUrl(), requestMapping);
        if (Objects.isNull(handlerMethod)) {
            return resultList;
        }
        for (ControllerReturnFieldAnalysisRegister analysisRegister : this.fieldAnalysisRegisters) {
            Boolean matchResult = analysisRegister.match(handlerMethod);
            if (!Boolean.TRUE.equals(matchResult)) continue;
            resultList = analysisRegister.analyzeField(handlerMethod);
            break;
        }
        return resultList;
    }

    private HandlerMethod getHandlerMethod(String url, String requestMapping) {
        url = url.startsWith(this.contextPath) ? url.substring(this.contextPath.length()) : url;
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        HandlerMethod handlerMethod = null;
        block0: for (Map.Entry handlerMethodEntry : handlerMethods.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)handlerMethodEntry.getKey();
            HandlerMethod tempHandlerMethod = (HandlerMethod)handlerMethodEntry.getValue();
            Set directPaths = requestMappingInfo.getDirectPaths();
            if (!directPaths.contains(url)) continue;
            RequestMethodsRequestCondition methodsCondition = requestMappingInfo.getMethodsCondition();
            Set methods = methodsCondition.getMethods();
            for (RequestMethod requestMethod : methods) {
                if (!requestMethod.name().equalsIgnoreCase(requestMapping.toUpperCase())) continue;
                handlerMethod = tempHandlerMethod;
                handlerMethod = handlerMethod.createWithResolvedBean();
                continue block0;
            }
        }
        return handlerMethod;
    }
}

