/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service.async;

import com.bizunited.nebula.common.service.async.AsyncTask;
import com.bizunited.nebula.common.service.async.AsyncThreadHandler;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AsyncTaskThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTaskThreadPoolExecutor.class);

    public AsyncTaskThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    @Override
    protected void beforeExecute(Thread currentThread, Runnable r) {
        AsyncTask currentAsyncTask;
        List<AsyncThreadHandler> asyncThreadHandlers;
        super.beforeExecute(currentThread, r);
        if (r instanceof AsyncTask && !CollectionUtils.isEmpty(asyncThreadHandlers = (currentAsyncTask = (AsyncTask)r).getAsyncThreadHandlers())) {
            for (AsyncThreadHandler asyncThreadHandler : asyncThreadHandlers) {
                asyncThreadHandler.writeContext(currentThread);
            }
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        AsyncTask currentAsyncTask;
        List<AsyncThreadHandler> asyncThreadHandlers;
        super.afterExecute(r, t);
        Thread taskThread = Thread.currentThread();
        AsyncTask asyncTask = (AsyncTask)r;
        if (t == null) {
            asyncTask.doSuccess();
        } else {
            LOGGER.error(t.getMessage(), t);
            asyncTask.doError(t);
        }
        if (r instanceof AsyncTask && !CollectionUtils.isEmpty(asyncThreadHandlers = (currentAsyncTask = (AsyncTask)r).getAsyncThreadHandlers())) {
            for (AsyncThreadHandler asyncThreadHandler : asyncThreadHandlers) {
                asyncThreadHandler.clearContext(taskThread);
            }
        }
    }
}

