/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service.redis;

import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RLock;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultRedisMutexServiceImpl
implements RedisMutexService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRedisMutexServiceImpl.class);
    private static final String REDIS_ERROR = "RedisMutexService key is null!!";
    private static final String TRY_TIMES_ERROR = "RedisMutexService tryTime value Must be greater than 1";
    @Autowired
    private RedissonClient redissonClient;

    @Override
    public void lock(String key) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        rlock.lock();
    }

    @Override
    public boolean tryLock(String key, TimeUnit unit, int waitTime) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        Validate.notNull((Object)((Object)unit), (String)REDIS_ERROR, (Object[])new Object[0]);
        Validate.isTrue((waitTime > 0 ? 1 : 0) != 0, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        try {
            return rlock.tryLock((long)waitTime, unit);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean tryLock(String key, int waitTime, int leaseTime, TimeUnit unit) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        Validate.notNull((Object)((Object)unit), (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        try {
            return rlock.tryLock((long)waitTime, (long)leaseTime, unit);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean tryLock(String key) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        return rlock.tryLock();
    }

    @Override
    public boolean tryLock(String key, TimeUnit unit, int waitTime, int attempts) {
        Validate.isTrue((waitTime >= 1 ? 1 : 0) != 0, (String)TRY_TIMES_ERROR, (Object[])new Object[0]);
        boolean result = false;
        for (int times = 0; times < attempts; ++times) {
            result = this.tryLock(key, unit, waitTime);
            if (!result) continue;
            return result;
        }
        return result;
    }

    @Override
    public void unlock(String key) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        rlock.unlock();
    }

    @Override
    public boolean islock(String key) {
        Validate.notBlank((CharSequence)key, (String)REDIS_ERROR, (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        return rlock.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndIncrement(String code, long min) {
        Validate.notNull((Object)code, (String)"code\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        long currentMin = min <= 0L ? 0L : min;
        String lockCode = StringUtils.join((Object[])new String[]{"_async_", code});
        long currentValue = 0L;
        try {
            this.lock(lockCode);
            currentValue = this.redissonClient.getAtomicLong(code).getAndIncrement();
            if (currentValue < currentMin) {
                this.redissonClient.getAtomicLong(code).set(currentMin + 1L);
                currentValue = currentMin;
            }
        }
        finally {
            this.unlock(lockCode);
        }
        return currentValue;
    }

    @Override
    public Long getIncrement(String code) {
        Validate.notNull((Object)code, (String)"code\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        RAtomicLong atomicLong = this.redissonClient.getAtomicLong(code);
        if (!atomicLong.isExists()) {
            return null;
        }
        return atomicLong.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndIncrement(String code, long min, long expire, TimeUnit unit) {
        Validate.notNull((Object)code, (String)"code\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)unit), (String)"\u65f6\u95f4\u5355\u4f4d\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        long currentMin = min <= 0L ? 0L : min;
        String lockCode = StringUtils.join((Object[])new String[]{"_async_", code});
        long currentValue = 0L;
        try {
            this.lock(lockCode);
            RAtomicLong atomicLong = this.redissonClient.getAtomicLong(code);
            currentValue = atomicLong.getAndIncrement();
            if (currentValue < currentMin) {
                atomicLong.set(currentMin + 1L);
                currentValue = currentMin;
            }
            atomicLong.expire(expire, unit);
        }
        finally {
            this.unlock(lockCode);
        }
        return currentValue;
    }

    @Override
    public String getAndIncrement(String code, long min, Integer mixStrLen, long expire, TimeUnit unit) {
        Validate.isTrue((mixStrLen > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6570\u5b57\u683c\u5f0f\u5316\u7684\u65f6\u5019\uff0c\u8bbe\u5b9a\u7684\u683c\u5f0f\u5316\u6700\u5c0f\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        long current = expire <= 0L ? this.getAndIncrement(code, min) : this.getAndIncrement(code, min, expire, unit);
        String currentValue = String.valueOf(current);
        int currentStrLen = currentValue.length();
        if (currentStrLen >= mixStrLen) {
            return currentValue;
        }
        char[] fillChars = new char[mixStrLen.intValue()];
        Arrays.fill(fillChars, 0, (int)mixStrLen, '0');
        DecimalFormat format = new DecimalFormat(new String(fillChars));
        return format.format(current);
    }

    @Override
    public String getAndIncrement(String code, long min, Integer mixStrLen) {
        return this.getAndIncrement(code, min, mixStrLen, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void setMCode(String mapName, String mapKey, String content, long min) {
        Validate.notBlank((CharSequence)mapName, (String)"\u8fdb\u884credission client\u865a\u62dfmap\u7ed3\u6784\u64cd\u4f5c\u65f6\uff0cmap name\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mapKey, (String)"\u8fdb\u884credission client\u865a\u62dfmap\u7ed3\u6784\u64cd\u4f5c\u65f6\uff0cmap name\u4e0b\u7684key\u503c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)content, (String)"\u8fdb\u884credission client\u865a\u62dfmap\u7ed3\u6784\u64cd\u4f5c\u65f6\uff0cmap name\u4e0b\u7684key\u503c\u5bf9\u5e94\u7684value\u5185\u5bb9\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        if (min < 0L) {
            throw new IllegalArgumentException("\u8fdb\u884credission client\u865a\u62dfmap\u7ed3\u6784\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u8bbe\u5b9a\u4e00\u4e2a\u6709\u6548\u7684\u8fc7\u671f\u65f6\u95f4!!");
        }
        RMapCache currentMap = this.redissonClient.getMapCache(mapName);
        Validate.notNull((Object)currentMap, (String)"\u672a\u83b7\u53d6\u5230redis\u76f8\u5173\u4fe1\u606f", (Object[])new Object[0]);
        currentMap.put((Object)mapKey, (Object)content, min, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getMCode(String mapName, String mapKey) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{mapName, mapKey})) {
            return null;
        }
        RMapCache currentMap = this.redissonClient.getMapCache(mapName);
        if (currentMap == null) {
            return null;
        }
        Object currentValue = currentMap.get((Object)mapKey);
        return currentValue == null ? null : currentValue.toString();
    }

    @Override
    public Object removeMCode(String mapName, String mapKey) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{mapName, mapKey})) {
            return null;
        }
        RMapCache currentMap = this.redissonClient.getMapCache(mapName);
        if (currentMap == null) {
            return null;
        }
        return currentMap.remove((Object)mapKey);
    }

    @Override
    public <K, V> Set<Map.Entry<K, V>> entrySet(String mapName) {
        if (StringUtils.isBlank((CharSequence)mapName)) {
            return null;
        }
        RMapCache currentMap = this.redissonClient.getMapCache(mapName);
        return currentMap.entrySet();
    }
}

