/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service.register;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizunited.nebula.common.register.ControllerReturnFieldAnalysisRegister;
import com.bizunited.nebula.common.vo.AnalysisFieldInfoVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

@Component
public class ControllerReturnFieldAnalysisPageRegisterImpl
implements ControllerReturnFieldAnalysisRegister {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerReturnFieldAnalysisPageRegisterImpl.class);

    @Override
    public Boolean match(HandlerMethod handlerMethod) {
        if (Objects.isNull(handlerMethod)) {
            return Boolean.FALSE;
        }
        try {
            Type genericReturnType = handlerMethod.getMethod().getGenericReturnType();
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
            return ParameterizedTypeImpl.class.equals(actualTypeArgument.getClass()) && Page.class.equals((Object)((ParameterizedTypeImpl)actualTypeArgument).getRawType());
        }
        catch (Exception e) {
            LOGGER.warn("ControllerReturnFieldAnalysisPageRegisterImpl \u5339\u914d\u63a5\u53e3\u65b9\u6cd5\u5931\u8d25,\u8df3\u8fc7\u6b64\u7b56\u7565\u7684\u6267\u884c");
            return Boolean.FALSE;
        }
    }

    @Override
    public List<AnalysisFieldInfoVo> analyzeField(HandlerMethod handlerMethod) {
        List<Object> resultList = Lists.newArrayList();
        if (Objects.isNull(handlerMethod)) {
            return resultList;
        }
        try {
            Type genericReturnType = handlerMethod.getMethod().getGenericReturnType();
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
            Class dataClass = (Class)((ParameterizedTypeImpl)actualTypeArgument).getActualTypeArguments()[0];
            ArrayList dataFieldList = Lists.newArrayList();
            this.buildClassAllField(dataClass, dataFieldList);
            resultList = dataFieldList.stream().filter(field -> !field.getName().equals("serialVersionUID")).map(field -> {
                AnalysisFieldInfoVo fieldInfoVo = new AnalysisFieldInfoVo();
                fieldInfoVo.setFieldName(field.getName());
                fieldInfoVo.setJavaClassName(field.getType().getName());
                ApiModelProperty apiModelProperty = field.getDeclaredAnnotation(ApiModelProperty.class);
                if (Objects.nonNull(apiModelProperty)) {
                    fieldInfoVo.setFieldComment(apiModelProperty.value());
                }
                return fieldInfoVo;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.warn("ControllerReturnFieldAnalysisPageRegisterImpl \u63a5\u53e3\u89e3\u6790\u8fd4\u56de\u503c\u5b57\u6bb5\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return resultList;
    }

    private void buildClassAllField(Class<?> dataClass, List<Field> fieldList) {
        Object[] declaredFields = dataClass.getDeclaredFields();
        if (declaredFields.length > 0) {
            fieldList.addAll(0, Lists.newArrayList((Object[])declaredFields));
        }
        if (Objects.nonNull(dataClass.getSuperclass())) {
            this.buildClassAllField(dataClass.getSuperclass(), fieldList);
        }
    }
}

