/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtils() {
        throw new IllegalStateException("\u9759\u6001\u5de5\u5177\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static <T> T json2Obj(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("json\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5json\u6570\u636e\uff1a%s", json));
        }
    }

    public static <T> T json2Obj(String json, TypeReference<T> typeReference) {
        Object t;
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            t = objectMapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("json\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5json\u6570\u636e\uff1a%s", json));
        }
        return (T)t;
    }

    public static <T> T convert(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        return (T)objectMapper.convertValue(obj, clazz);
    }

    public static <T> T convert(Object obj, TypeReference<T> typeReference) {
        if (obj == null) {
            return null;
        }
        return (T)objectMapper.convertValue(obj, typeReference);
    }

    public static <T extends Collection<E>, E> T convert(Object obj, Class<T> collectionClass, Class<E> elementClass) {
        if (obj == null) {
            return null;
        }
        CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(collectionClass, elementClass);
        return (T)((Collection)objectMapper.convertValue(obj, (JavaType)collectionType));
    }

    public static <T extends Collection<E>, E> T convert(Object obj, ParameterizedType parameterizedType) {
        Class<?> elementClass;
        Class<?> collectionClass;
        if (obj == null) {
            return null;
        }
        Validate.notNull((Object)parameterizedType, (String)"\u53c2\u6570\u5316\u96c6\u5408\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        String rawTypeName = parameterizedType.getRawType().getTypeName();
        try {
            collectionClass = Class.forName(rawTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u7c7b\uff1a%s", rawTypeName));
        }
        Object[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Validate.notEmpty((Object[])actualTypeArguments, (String)"\u76ee\u6807\u96c6\u5408\u7c7b\u975e\u96c6\u5408\u7c7b\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        String elementTypeName = actualTypeArguments[0].getTypeName();
        try {
            elementClass = Class.forName(elementTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u7c7b\uff1a%s", elementTypeName));
        }
        CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(collectionClass, elementClass);
        return (T)((Collection)objectMapper.convertValue(obj, (JavaType)collectionType));
    }

    public static JSONObject toJSONObject(Object obj) {
        if (obj == null) {
            return null;
        }
        Object json = JSON.toJSON((Object)obj);
        if (json instanceof JSONObject) {
            return (JSONObject)json;
        }
        return JSONObject.parseObject((String)json.toString());
    }

    public static String obj2JsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bf9\u8c61\u8f93\u51fajson\u9519\u8bef");
        }
    }

    static {
        objectMapper.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }
}

