/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.boot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@SpringBootApplication(scanBasePackages={"com.bizunited.nebula.*"})
@EnableTransactionManagement
@EnableSwagger2WebMvc
@EnableDiscoveryClient
public class ApplicationBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationBootstrap.class);

    public static void main(String[] args) {
        ConfigurableApplicationContext application = new SpringApplicationBuilder(new Class[]{ApplicationBootstrap.class}).bannerMode(Banner.Mode.OFF).web(WebApplicationType.SERVLET).run(args);
        ConfigurableEnvironment env = application.getEnvironment();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        LOGGER.info("\n----------------------------------------------------------\n\tApplication nebula-venus is running! Access URLs:\n\t\u672c\u5730\u8bbf\u95ee\u5730\u5740: \t\thttp://localhost:" + port + path + "/\n\tswagger\u5730\u5740: \t\thttp://localhost:" + port + path + "/doc.html\n----------------------------------------------------------");
    }
}

