/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.boot.event;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;
import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliYunVenusFileEventListener
implements VenusFileEventListener {
    private static final Logger log = LoggerFactory.getLogger(AliYunVenusFileEventListener.class);
    private String accessKey;
    private String secretKey;
    private String endpoint;
    private String bucket;

    public AliYunVenusFileEventListener(String accessKey, String secretKey, String endpoint, String bucket) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.endpoint = endpoint;
        this.bucket = bucket;
    }

    private String handleRelativePath(String relativePath) {
        relativePath = relativePath.startsWith("/") ? relativePath.substring(1) : relativePath;
        relativePath = relativePath.endsWith("/") ? relativePath : relativePath + "/";
        return relativePath;
    }

    public void onSaveFile(String relativePath, String fileName, String fileRename, byte[] fileContext) {
        try {
            OSS ossClient = this.buildOssClient();
            ossClient.putObject(this.bucket, this.handleRelativePath(relativePath) + fileRename, (InputStream)new ByteArrayInputStream(fileContext));
        }
        catch (Exception e) {
            log.error(String.format("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef:%s", e.getMessage()), (Throwable)e);
        }
    }

    public void onDeleteFile(String relativePath, String fileName, String fileRename) {
        try {
            OSS ossClient = this.buildOssClient();
            ossClient.deleteObject(this.bucket, this.handleRelativePath(relativePath) + fileRename);
        }
        catch (Exception e) {
            log.error(String.format("\u5220\u9664\u6587\u4ef6\u9519\u8bef:%s", e.getMessage()), (Throwable)e);
        }
    }

    public byte[] onReadFileContent(String relativePath, String fileRename) {
        byte[] fileContents = new byte[]{};
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            OSS ossClient = this.buildOssClient();
            OSSObject ossObject = ossClient.getObject(this.bucket, this.handleRelativePath(relativePath) + fileRename);
            int maxLen = 204800;
            byte[] readContext = new byte[maxLen];
            while (true) {
                int realen;
                if ((realen = ossObject.getObjectContent().read(readContext, 0, maxLen)) == -1) {
                    fileContents = out.toByteArray();
                    break;
                }
                out.write(readContext, 0, realen);
            }
        }
        catch (IOException e) {
            log.error(String.format("\u65e0\u6cd5\u8bfb\u53d6\u5bf9\u8c61\u5185\u5bb9\u6d41:%s", e.getMessage()), (Throwable)e);
        }
        return fileContents;
    }

    private OSS buildOssClient() {
        return new OSSClientBuilder().build(this.endpoint, this.accessKey, this.secretKey);
    }
}

