/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.boot.event;

import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.obs.services.ObsClient;
import com.obs.services.model.ObsObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaWeiVenusFileEventListenerImpl
implements VenusFileEventListener {
    private static final Logger log = LoggerFactory.getLogger(HuaWeiVenusFileEventListenerImpl.class);
    private String accessKey;
    private String secretKey;
    private String endpoint;
    private String bucket;

    public HuaWeiVenusFileEventListenerImpl(String accessKey, String secretKey, String endpoint, String bucket) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.endpoint = endpoint;
        this.bucket = bucket;
    }

    public void onSaveFile(String relativePath, String fileName, String fileRename, byte[] fileContext) {
        try (ObsClient obsClient = this.buildObsClient();){
            obsClient.putObject(this.bucket, relativePath + File.separator + fileRename, (InputStream)new ByteArrayInputStream(fileContext));
        }
        catch (Exception e) {
            log.error(String.format("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef:%s", e.getMessage()), (Throwable)e);
        }
        log.debug("=======do onSaveFile");
    }

    public void onDeleteFile(String relativePath, String fileName, String fileRename) {
        try (ObsClient obsClient = this.buildObsClient();){
            obsClient.deleteObject(this.bucket, relativePath + File.separator + fileRename);
        }
        catch (Exception e) {
            log.error(String.format("\u5220\u9664\u6587\u4ef6\u9519\u8bef:%s", e.getMessage()), (Throwable)e);
        }
    }

    public byte[] onReadFileContent(String relativePath, String fileRename) {
        byte[] fileContents = new byte[]{};
        try (ObsClient obsClient = this.buildObsClient();
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ObsObject obsObject = obsClient.getObject(this.bucket, relativePath + File.separator + fileRename);
            int maxLen = 204800;
            byte[] readContext = new byte[maxLen];
            while (true) {
                int realen;
                if ((realen = obsObject.getObjectContent().read(readContext, 0, maxLen)) == -1) {
                    fileContents = out.toByteArray();
                    break;
                }
                out.write(readContext, 0, realen);
            }
        }
        catch (IOException e) {
            log.error(String.format("\u65e0\u6cd5\u8bfb\u53d6\u5bf9\u8c61\u5185\u5bb9\u6d41:%s", e.getMessage()), (Throwable)e);
        }
        return fileContents;
    }

    private ObsClient buildObsClient() {
        return new ObsClient(this.accessKey, this.secretKey, this.endpoint);
    }
}

