/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.boot.event;

import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.Upload;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentVenusFileEventListener
implements VenusFileEventListener {
    private static final Logger log = LoggerFactory.getLogger(TencentVenusFileEventListener.class);
    private String accessKey;
    private String secretKey;
    private String endpoint;
    private String bucket;

    public TencentVenusFileEventListener(String accessKey, String secretKey, String endpoint, String bucket) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.endpoint = endpoint;
        this.bucket = bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSaveFile(String relativePath, String fileName, String fileRename, byte[] fileContext) {
        File file = new File(fileRename);
        try (FileOutputStream output = new FileOutputStream(file);
             BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);){
            bufferedOutput.write(fileContext);
        }
        catch (IOException e) {
            log.error(String.format("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef:%s", e.getMessage()), (Throwable)e);
        }
        COSClient cosclient = this.buildCosClient();
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager((COS)cosclient, threadPool);
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, relativePath + "/" + fileRename, file);
            long startTime = System.currentTimeMillis();
            Upload upload = transferManager.upload(putObjectRequest);
            TencentVenusFileEventListener.showTransferProgress((Transfer)upload);
            long endTime = System.currentTimeMillis();
            log.info(String.format("\u8017\u65f6\uff1a%d\u6beb\u79d2", endTime - startTime));
        }
        catch (CosClientException e) {
            log.error(String.format("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef:%s", e.getMessage()), (Throwable)e);
        }
        finally {
            transferManager.shutdownNow();
            cosclient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeleteFile(String relativePath, String fileName, String fileRename) {
        COSClient cosClient = this.buildCosClient();
        try {
            cosClient.deleteObject(this.bucket, relativePath + "/" + fileRename);
        }
        catch (Exception e) {
            log.error(String.format("\u5220\u9664\u6587\u4ef6\u9519\u8bef:%s", e.getMessage()), (Throwable)e);
        }
        finally {
            cosClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] onReadFileContent(String relativePath, String fileRename) {
        byte[] fileContents = new byte[]{};
        COSClient cosClient = this.buildCosClient();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            boolean useTrafficLimit = false;
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucket, relativePath + "/" + fileRename);
            if (useTrafficLimit) {
                getObjectRequest.setTrafficLimit(0x800000);
            }
            COSObject cosObject = cosClient.getObject(getObjectRequest);
            int maxLen = 204800;
            byte[] readContext = new byte[maxLen];
            while (true) {
                int realen;
                if ((realen = cosObject.getObjectContent().read(readContext, 0, maxLen)) == -1) {
                    fileContents = out.toByteArray();
                    break;
                }
                out.write(readContext, 0, realen);
            }
        }
        catch (IOException e) {
            log.error(String.format("\u65e0\u6cd5\u8bfb\u53d6\u5bf9\u8c61\u5185\u5bb9\u6d41:%s", e.getMessage()), (Throwable)e);
        }
        finally {
            cosClient.shutdown();
        }
        return fileContents;
    }

    private static void showTransferProgress(Transfer transfer) {
        log.info(transfer.getDescription());
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                return;
            }
            TransferProgress progress = transfer.getProgress();
            long so_far = progress.getBytesTransferred();
            long total = progress.getTotalBytesToTransfer();
            double pct = progress.getPercentTransferred();
            log.info(String.format("[%d / %d] = %.02f%%\n", so_far, total, pct));
        } while (!transfer.isDone());
        log.info("{}", (Object)transfer.getState());
    }

    private COSClient buildCosClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.accessKey, this.secretKey);
        Region region = new Region(this.endpoint);
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setHttpProtocol(HttpProtocol.https);
        return new COSClient((COSCredentials)cred, clientConfig);
    }
}

