/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.boot.filter;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.venus.boot.transform.VenusUserIdentity;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class IgnoreJwtFilter
extends OncePerRequestFilter {
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;
    private static final String JWT_HEADER = "jwt";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String jwtText = request.getHeader(JWT_HEADER);
        if (!StringUtils.isBlank((CharSequence)jwtText)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String user = this.simpleSecurityProperties.getIndependencyUser();
        String[] roleCodes = this.simpleSecurityProperties.getIndependencyRoles();
        if (StringUtils.isBlank((CharSequence)user) || roleCodes == null || roleCodes.length == 0) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ArrayList authorities = Lists.newArrayList();
        for (String roleCode : roleCodes) {
            SimpleGrantedAuthority simpleGrantedAuthority = new SimpleGrantedAuthority(roleCode);
            authorities.add(simpleGrantedAuthority);
        }
        VenusUserIdentity venusUserIdentity = new VenusUserIdentity(user, TenantUtils.getTenantCode(), roleCodes);
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)user, (Object)"123456", (Collection)authorities);
        authenticationToken.setDetails((Object)venusUserIdentity);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        securityContext.setAuthentication((Authentication)authenticationToken);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

