package com.bizunited.nebula.venus.client.local.simple.controller;

import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.venus.client.local.simple.vo.PhotoWallSimpleForm;
import com.bizunited.nebula.venus.client.sdk.service.PhotoWallService;

/**
 * 用于进行照片墙客户端操作的示例
 * @author yinwenjie
 */
@RestController
@RequestMapping("/v1/venus/simple/photoWallSimple")
public class PhotoWallSimpleController extends BaseController {
  
  @Autowired
  private PhotoWallService photoWallService;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(PhotoWallSimpleController.class);
  
  @RequestMapping(path = "testUp" ,  method = RequestMethod.POST)
  public ResponseModel testUp(@RequestParam("fileCode") String[] fileCodes) {
    PhotoWallSimpleForm form = new PhotoWallSimpleForm();
    Date now = new Date();
    form.setBillCode("billCode");
    form.setTenantCode("default");
    form.setBusinessTime(now);
    form.setStoreCode("storeCode");
    form.setStoreName("storeName，名字");
    form.setCreateAccount("admin");
    form.setCreateTime(now);
    form.setModifyAccount("admin");
    form.setModifyTime(now);
    
    try {
      this.photoWallService.up(fileCodes, form);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  
  @RequestMapping(path = "testDismiss" ,  method = RequestMethod.POST)
  public ResponseModel testDismiss() {
    try {
      // 注意这里的code是：PhotoWallSimpleRegister
      // 来自于注册器PhotoWallSimpleRegister中，code方法的返回值
      this.photoWallService.dismiss("PhotoWallSimpleRegister", "billCode");
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  } 
}
