package com.bizunited.nebula.venus.client.local.simple.vo;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.bizunited.nebula.venus.client.sdk.annotation.EsFieldType;
import com.bizunited.nebula.venus.client.sdk.annotation.PhotoWallField;
import com.bizunited.nebula.venus.client.sdk.vo.PhotoWallRegisterForm;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 示例的照片墙类型表单结构描述
 * @author yinwenjie
 */
public class PhotoWallSimpleForm extends PhotoWallRegisterForm {
  /**
   * 门店编码
   */
  @PhotoWallField(fieldName = "门店编码" , analyzer = false , esFieldType = EsFieldType.Text)
  private String storeCode;
  /**
   * 门店名称
   */
  @PhotoWallField(fieldName = "门店名称" , analyzer = true , esFieldType = EsFieldType.Text)
  private String storeName;
  /**
   * 业务发生时间
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @PhotoWallField(fieldName = "业务发生时间" , analyzer = false , esFieldType = EsFieldType.Date)
  private Date businessTime;
  
  public String getStoreCode() {
    return storeCode;
  }
  public void setStoreCode(String storeCode) {
    this.storeCode = storeCode;
  }
  public String getStoreName() {
    return storeName;
  }
  public void setStoreName(String storeName) {
    this.storeName = storeName;
  }
  public Date getBusinessTime() {
    return businessTime;
  }
  public void setBusinessTime(Date businessTime) {
    this.businessTime = businessTime;
  }
}
