package com.bizunited.nebula.venus.service.local.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.springframework.data.elasticsearch.annotations.Document;

import com.bizunited.nebula.common.entity.TenantOpEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Set;

/**
 * 文档模型定义
 * @Author: Paul Chan
 * @Date: 2020-04-07 15:46
 */
@Entity
@Table(name = "engine_document")
@Document(indexName = "venus_document")
@ApiModel(value = "DocumentEntity" , description=" 文档模型定义")
public class DocumentEntity extends TenantOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -1426191867454597609L;
  /**
   * 父级文档
   */
  @ApiModelProperty("父级文档")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "parent_id", columnDefinition = "varchar(255) COMMENT '父级文档'")
  private DocumentEntity parent;
  /**
   * 标题
   */
  @ApiModelProperty("标题")
  @Column(name = "title", nullable = false, columnDefinition = "varchar(255) COMMENT '标题'")
  private String title;
  /**
   * 文件在本地的存储目录（相对位置，不包括）<br>
   */
  @ApiModelProperty(name="relativeLocal" , value="文件在本地的存储目录（相对位置，不包括）" , required= false)
  @Column(name = "relative_local", nullable = true , columnDefinition = "varchar(255) COMMENT '文件在本地的存储目录（相对位置，不包括）'")
  private String relativeLocal;
  /**
   * 重命名后的文件名字
   */
  @ApiModelProperty(name="fileName" , value="重命名后的文件名字" , required=false)
  @Column(name = "file_name", nullable = true , unique = true, columnDefinition = "varchar(255) COMMENT '重命名后的文件名字'")
  private String fileName;
  /**
   * 排序，升序排序
   */
  @ApiModelProperty("排序，升序排序")
  @Column(name = "sort", nullable = false, columnDefinition = "int(11) COMMENT '排序，升序排序'")
  private Integer sort;
  /**
   * 子级文档
   */
  @OrderBy("sort")
  @ApiModelProperty("子级文档")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "parent")
  private Set<DocumentEntity> documents;
  /**
   * 文档内容
   */
  @Transient
  @ApiModelProperty("文档内容")
  private String content;
  
  public DocumentEntity getParent() {
    return parent;
  }
  public void setParent(DocumentEntity parent) {
    this.parent = parent;
  }
  public String getTitle() {
    return title;
  }
  public void setTitle(String title) {
    this.title = title;
  }
  public String getRelativeLocal() {
    return relativeLocal;
  }
  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public Integer getSort() {
    return sort;
  }
  public void setSort(Integer sort) {
    this.sort = sort;
  }
  public Set<DocumentEntity> getDocuments() {
    return documents;
  }
  public void setDocuments(Set<DocumentEntity> documents) {
    this.documents = documents;
  }
  public String getContent() {
    return content;
  }
  public void setContent(String content) {
    this.content = content;
  }
}
