package com.bizunited.nebula.venus.service.local.entity;

import com.bizunited.nebula.common.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * 普通文件附件、图片附件的记录信息
 * @author yinwenjie 
 */
@ApiModel(value = "OrdinaryFileEntity" , description=" 普通文件附件、图片附件的记录信息")
@Entity
@Table(name = "engine_file" , indexes={@Index(columnList="original_name , relative_local") , @Index(columnList="effective_date")})
public class OrdinaryFileEntity extends TenantOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -8713644330539585178L;
  /**
   * 文件的上传者
   */
  @ApiModelProperty(name="commitUser" , value="文件的上传者" , required=false)
  @Column(name = "commit_user", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '文件的上传者'")
  private String commitUser;
  /**
   * 重命名后的文件名字
   */
  @ApiModelProperty(name="fileName" , value="重命名后的文件名字" , required=false)
  @Column(name = "file_name", nullable = true , unique = true, columnDefinition = "varchar(255) COMMENT '重命名后的文件名字'")
  private String fileName;
  /**
   * 重命名前的文件名字
   */
  @ApiModelProperty(name="originalFileName" , value="重命名前的文件名字" , required=false)
  @Column(name = "original_name", nullable = true, columnDefinition = "varchar(255) COMMENT '重命名前的文件名字'")
  private String originalFileName;
  /**
   * 文件在本地的存储目录（相对位置，不包括）<br>
   */
  @ApiModelProperty(name="relativeLocal" , value="文件在本地的存储目录（相对位置，不包括）" , required=false)
  @Column(name = "relative_local", nullable = true , columnDefinition = "varchar(255) COMMENT '文件在本地的存储目录（相对位置，不包括）'")
  private String relativeLocal;
  /**
   * 文件的扩展类型，例如：png、gif、jpg等
   */
  @ApiModelProperty(name="prefix" , value="文件的扩展类型，例如：png、gif、jpg等" , required=false)
  @Column(name = "prefix", nullable = true, length = 32 , columnDefinition = "varchar(32) COMMENT '文件的扩展类型，例如：png、gif、jpg等'")
  private String prefix;
  /**
   * 文件有效期截止，默认为3999-01-01 00:00:00
   */
  @ApiModelProperty(name="effectiveDate" , value="文件有效期截止" , required=false)
  @Column(name = "effective_date", nullable = true, columnDefinition = "datetime COMMENT '文件有效期截止，默认为3999-01-01 00:00:00'")
  private Date effectiveDate;
  /**
   * 文件大小单位Byte（字节）
   */
  @ApiModelProperty(name="fileSize" , value="文件大小单位Byte（字节）" , required=false)
  @Column(name = "file_size", nullable = true, columnDefinition = "bigint(20) COMMENT '文件大小单位Byte（字节）'")
  private Long fileSize;
  
  public String getCommitUser() {
    return commitUser;
  }
  public void setCommitUser(String commitUser) {
    this.commitUser = commitUser;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public String getOriginalFileName() {
    return originalFileName;
  }
  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }
  public String getRelativeLocal() {
    return relativeLocal;
  }
  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }
  public String getPrefix() {
    return prefix;
  }
  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }
  public Date getEffectiveDate() {
    return effectiveDate;
  }
  public void setEffectiveDate(Date effectiveDate) {
    this.effectiveDate = effectiveDate;
  }
  public Long getFileSize() {
    return fileSize;
  }
  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }
}
