/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/venus/files"})
public class FileController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private FileHandleService fileHandleService;
    private static final String UPLOAD_ERROR = "you must upload least one file !";

    @ApiOperation(value="\u8fd9\u4e2a\u65b9\u6cd5\u53ef\u7528\u4e8e\u4e00\u6b21\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6\u9644\u4ef6\uff08\u652f\u6301\u6587\u4ef6\u9644\u4ef6\u4e0a\u4f20\uff09", notes="1\u3001\u76ee\u524d\u652f\u6301\u666e\u901a\u6587\u4ef6\uff0c\u666e\u901a\u6587\u4ef6\u901a\u8fc7\u914d\u7f6e\u6587\u4ef6\u8fdb\u884c\u540e\u7f00\u540d\u7684\u767d\u540d\u5355\u63a7\u52362\u3001\u53ea\u80fd\u4e0a\u4f20\u5927\u5c0f\u9ed8\u8ba4\u4e0d\u8d85\u8fc72048KB\u7684\u6587\u4ef6\uff08\u53ef\u8bbe\u7f6e\uff09\uff0c\u4e5f\u5c31\u662f\u8bf4\u5982\u679c\u4e0a\u4f20\u7684\u6587\u4ef6\u8f83\u5927\uff0c\u90a3\u4e48\u5ba2\u6237\u7aef\u9700\u8981\u81ea\u884c\u538b\u7f29\u4e00\u4e0b<br>3\u3001\u4e0a\u4f20\u6210\u529f\u540e\uff0c\u8fd9\u4e2a\u8bf7\u6c42\u5c06\u8fd4\u56de\u6587\u4ef6\u5728\u670d\u52a1\u5668\u7aef\u4fdd\u5b58\u7684\u552f\u4e00id\u8fd8\u5305\u62ec\u4e86\u6587\u4ef6\u5bf9\u8c61\u7684\u5176\u5b83\u4fe1\u606f\uff0c\u5982\u679c\u662f\u56fe\u7247\u6587\u4ef6\uff0c\u90a3\u4e48\u5728\u6587\u4ef6\u8bbf\u95ee\u65f6\u8fd8\u53ef\u4ee5\u52a0\u76f8\u5e94\u7279\u6548\u54e6\uff0c\u5177\u4f53\u8bf7\u53c2\u89c1/v1/kuiper/images\u4e0b\u7684controller api\u8bf4\u660e\u4fe1\u606f\uff09")
    @RequestMapping(path={"/fileUpload/{subsystem}"}, method={RequestMethod.POST})
    public ResponseModel fileUpload(@PathVariable(value="subsystem") String subsystem, @RequestParam(name="effective", required=false) @ApiParam(required=false, name="effective", value="\u8bbe\u5b9a\u7684\u6587\u4ef6\u6709\u6548\u671f\u65f6\u957f\uff0c\u65f6\u957f\u5355\u4f4d\u4e3a\u201c\u5929\u201d\u3002\u53ef\u4ee5\u4e0d\u4f20\u5165\uff0c\u4e0d\u4f20\u5165\u8868\u793a\u6c38\u4e45\u6709\u6548") Integer effective, @RequestParam(name="file", required=true) @ApiParam(required=true, name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u5bf9\u8c61\uff0c\u63d0\u4ea4\u7684\u8868\u5355\u4fe1\u606f\u4e2d\uff0c\u8bf7\u547d\u540d\u4e3afiles\uff08\u652f\u6301\u591a\u4e2a\u6587\u4ef6\uff0c\u5efa\u8bae\u4e0d\u8d85\u8fc75\u4e2a\u6587\u4ef6\uff09") MultipartFile[] files) {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException(UPLOAD_ERROR);
        }
        try {
            List uploadPojos = this.fileHandleService.fileUpload(subsystem, this.findCurrentAccount(), effective, files);
            return this.buildHttpResult(uploadPojos);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8fd9\u4e2a\u65b9\u6cd5\u53ef\u7528\u4e8e\u4e00\u6b21\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6\u9644\u4ef6\uff08\u652f\u6301\u6587\u4ef6\u9644\u4ef6\u4e0a\u4f20\uff09", notes="1\u3001\u76ee\u524d\u652f\u6301\u666e\u901a\u6587\u4ef6\uff0c\u666e\u901a\u6587\u4ef6\u901a\u8fc7\u914d\u7f6e\u6587\u4ef6\u8fdb\u884c\u540e\u7f00\u540d\u7684\u767d\u540d\u5355\u63a7\u52362\u3001\u53ea\u80fd\u4e0a\u4f20\u5927\u5c0f\u9ed8\u8ba4\u4e0d\u8d85\u8fc72048KB\u7684\u6587\u4ef6\uff08\u53ef\u8bbe\u7f6e\uff09\uff0c\u4e5f\u5c31\u662f\u8bf4\u5982\u679c\u4e0a\u4f20\u7684\u6587\u4ef6\u8f83\u5927\uff0c\u90a3\u4e48\u5ba2\u6237\u7aef\u9700\u8981\u81ea\u884c\u538b\u7f29\u4e00\u4e0b<br>3\u3001\u4e0a\u4f20\u6210\u529f\u540e\uff0c\u8fd9\u4e2a\u8bf7\u6c42\u5c06\u8fd4\u56de\u6587\u4ef6\u5728\u670d\u52a1\u5668\u7aef\u4fdd\u5b58\u7684\u552f\u4e00id\u8fd8\u5305\u62ec\u4e86\u6587\u4ef6\u5bf9\u8c61\u7684\u5176\u5b83\u4fe1\u606f\uff0c\u5982\u679c\u662f\u56fe\u7247\u6587\u4ef6\uff0c\u90a3\u4e48\u5728\u6587\u4ef6\u8bbf\u95ee\u65f6\u8fd8\u53ef\u4ee5\u52a0\u76f8\u5e94\u7279\u6548\u54e6\uff0c\u5177\u4f53\u8bf7\u53c2\u89c1/v1/kuiper/images\u4e0b\u7684controller api\u8bf4\u660e\u4fe1\u606f\uff09")
    @RequestMapping(path={"/fileUploadBase64/{subsystem}"}, method={RequestMethod.POST})
    public ResponseModel fileUpload(@PathVariable(value="subsystem") String subsystem, @RequestParam(name="effective", required=false) @ApiParam(required=false, name="effective", value="\u8bbe\u5b9a\u7684\u6587\u4ef6\u6709\u6548\u671f\u65f6\u957f\uff0c\u65f6\u957f\u5355\u4f4d\u4e3a\u201c\u5929\u201d\u3002\u53ef\u4ee5\u4e0d\u4f20\u5165\uff0c\u4e0d\u4f20\u5165\u8868\u793a\u6c38\u4e45\u6709\u6548") Integer effective, @RequestParam(name="fileNanmes", required=true) @ApiParam(required=true, name="fileNanmes", value="\u5e26\u6709\u6587\u4ef6\u540e\u7f00\uff0c\u4f46\u662f\u4e0d\u5e26\u6709\u6587\u4ef6\u8def\u5f84\u7684\u7684\u6587\u4ef6\u540d(\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] fileNanmes, @RequestParam(name="base64Contents", required=true) @ApiParam(required=true, name="base64Contents", value="\u7528base64\u7f16\u7801\u7684\u6587\u4ef6\u5185\u5bb9\uff08\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\uff09") String[] base64Contents) {
        try {
            List imageUploadPojos = this.fileHandleService.fileUpload(subsystem, this.findCurrentAccount(), effective, fileNanmes, base64Contents);
            return this.buildHttpResult(imageUploadPojos);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u6587\u4ef6\u7684\u6709\u6548\u671f\u8bbe\u7f6e\u4e3a\u201c\u6c38\u4e45\u201d\uff0c\u5b9e\u9645\u4e0a\u6709\u6548\u671f\u622a\u6b62\u65f6\u95f4\u5c06\u8bbe\u7f6e\u4e3a3999-01-01 00:00:00", notes="\u6587\u4ef6\u4fe1\u606f\u662f\u6587\u4ef6\u5b58\u50a8\u7684\u76f8\u5bf9\u8def\u5f84 + \u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u3002\u4f8b\u5982/file/20190402/3/e18ab4f4-9fad-46c7-9754-fdfc3f08c488.jpg")
    @RequestMapping(path={"/updatePermanentEffective"}, method={RequestMethod.PATCH})
    public ResponseModel updatePermanentEffective(@RequestParam(name="fileNanmes", required=true) @ApiParam(required=true, name="fileNanmes", value="\u5e26\u6709\u6587\u4ef6\u540e\u7f00\uff0c\u4e14\u5e26\u6709\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84\u7684\u7684\u6587\u4ef6\u540d(\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] fileNanmes) {
        try {
            this.fileHandleService.updateByEffective(fileNanmes);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u7ed9\u5b9a\u7684\u6587\u4ef6\u8def\u5f84\u548c\u6587\u4ef6\u540d\uff0c\u4e0b\u8f7d\u4e00\u822c\u6027\u6587\u4ef6\u3002")
    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    public void download(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="relativeLocal", value="\u76f8\u5bf9\u8def\u5f84", required=true) @RequestParam(value="relativeLocal") String relativeLocal, @ApiParam(name="fileName", value="\u6587\u4ef6\u540d\uff08\u91cd\u547d\u540d\u540e\u7684\uff09", required=true) @RequestParam(value="fileName") String fileName) throws IOException {
        byte[] bytes = this.fileHandleService.findContentByFilePathAndFileRename(relativeLocal, fileName);
        if (bytes == null) {
            return;
        }
        OrdinaryFileVo ordinaryFile = this.fileHandleService.findByFileNameAndRelativeLocal(fileName, relativeLocal);
        if (ordinaryFile == null) {
            return;
        }
        this.writeResponseFile(request, response, bytes, ordinaryFile.getOriginalFileName());
    }

    @ApiOperation(value="\u6309\u7167\u7ed9\u5b9a\u7684\u6587\u4ef6\u8def\u5f84\u548c\u6587\u4ef6\u540d\uff0c\u4e0b\u8f7d\u4e00\u822c\u6027\u6587\u4ef6\u3002")
    @RequestMapping(path={"/download/{subsystem}/{folder}/{randomfolder}/{fileName}"}, method={RequestMethod.GET})
    public void download(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="subsystem") String subsystem, @PathVariable(value="folder") String folder, @PathVariable(value="randomfolder") String randomfolder, @PathVariable(value="fileName") String fileName) throws IOException {
        String relativePath = StringUtils.join((Object[])new String[]{"/", subsystem, "/", folder, "/", randomfolder});
        this.download(request, response, relativePath, fileName);
    }

    @ApiOperation(value="\u6309\u7167\u7ed9\u5b9a\u7684\u6587\u4ef6\u8def\u5f84\u548c\u6587\u4ef6\u540d\uff0c\u4e0b\u8f7d\u4e00\u822c\u6027\u6587\u4ef6\u3002")
    @RequestMapping(path={"/download/{folder}/{randomfolder}/{fileName}"}, method={RequestMethod.GET})
    public void download(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="folder") String folder, @PathVariable(value="randomfolder") String randomfolder, @PathVariable(value="fileName") String fileName) throws IOException {
        String relativePath = StringUtils.join((Object[])new String[]{"/", folder, "/", randomfolder});
        this.download(request, response, relativePath, fileName);
    }

    @GetMapping(value={"/findByFileNameAndRelativeLocal"})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u540d\u548c\u76f8\u5bf9\u8def\u5f84\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f")
    public ResponseModel findByFileNameAndRelativeLocal(@ApiParam(name="relativeLocal", value="\u76f8\u5bf9\u8def\u5f84", required=true) @RequestParam(value="relativeLocal") String relativeLocal, @ApiParam(name="fileName", value="\u6587\u4ef6\u540d", required=true) @RequestParam(value="fileName") String fileName) {
        try {
            OrdinaryFileVo ordinaryFile = this.fileHandleService.findByFileNameAndRelativeLocal(fileName, relativeLocal);
            return this.buildHttpResultW(ordinaryFile, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByEffectiveDate"})
    @ApiOperation(value="\u6839\u636e\u8fc7\u671f\u65f6\u95f4\u67e5\u8be2\u6587\u4ef6")
    public ResponseModel findByEffectiveDate(@RequestParam(value="date") @DateTimeFormat(pattern="yyyy-MM-dd") Date date) {
        try {
            List files = this.fileHandleService.findByEffectiveDate(date);
            return this.buildHttpResultW(files, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u6587\u4ef6")
    @DeleteMapping(value={"deleteFiles"})
    public ResponseModel deleteFiles(@RequestParam(value="fileIds") String[] fileIds) {
        try {
            this.fileHandleService.deleteFiles(fileIds);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"deleteFileByFileRename"})
    @ApiOperation(value="\u5220\u9664\u6587\u4ef6\u7cfb\u7edf\u6587\u4ef6", notes="\u53ea\u5220\u9664\u6587\u4ef6\u7cfb\u7edf\u4e2d\u7684\u6587\u4ef6\uff0c\u4e0d\u4f1a\u5220\u9664\u6570\u636e\u5e93\u8bb0\u5f55")
    public ResponseModel deleteFile(@RequestParam(value="relativePath") String relativePath, @RequestParam(value="fileRename") String fileRename) {
        try {
            this.fileHandleService.deleteFile(relativePath, fileRename);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private String findCurrentAccount() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return "admin";
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return "admin";
        }
        return authentication.getName();
    }
}

