/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.images;

import com.bizunited.nebula.venus.service.local.service.images.ImageHandler;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class CutImageHandler
extends ImageHandler {
    private float ratio = -1.0f;
    private int destWith;
    private int destHeight;

    public CutImageHandler(ImageHandler nextHandler, float ratio) {
        super(nextHandler);
        this.ratio = ratio;
    }

    CutImageHandler(ImageHandler nextHandler, int destWith, int destHeight) {
        super(nextHandler);
        this.destWith = destWith;
        this.destHeight = destHeight;
    }

    @Override
    public BufferedImage dispose(BufferedImage srcImage) {
        int localDestWith;
        int localDestHeight;
        int sourceWith = srcImage.getWidth();
        int sourceHeight = srcImage.getHeight();
        if (sourceWith <= this.destWith || sourceHeight <= this.destHeight) {
            localDestHeight = sourceHeight;
            localDestWith = sourceWith;
        } else if (this.ratio != -1.0f) {
            localDestWith = Math.round((float)sourceWith * this.ratio);
            localDestHeight = Math.round((float)sourceHeight * this.ratio);
        } else {
            localDestWith = this.destWith;
            localDestHeight = this.destHeight;
        }
        BufferedImage cutImage = srcImage.getSubimage((sourceWith - localDestWith) / 2, (sourceHeight - localDestHeight) / 2, localDestWith, localDestHeight);
        BufferedImage outputImage = new BufferedImage(localDestWith, localDestHeight, 1);
        Graphics graphics = outputImage.getGraphics();
        graphics.drawImage(cutImage, 0, 0, null);
        graphics.dispose();
        BufferedImage nextResults = this.doNextHandler(outputImage);
        if (nextResults == null) {
            return outputImage;
        }
        return nextResults;
    }
}

