/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.internal;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.service.image.ImageHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.bizunited.nebula.venus.service.local.entity.OrdinaryFileEntity;
import com.bizunited.nebula.venus.service.local.repository.OrdinaryFileRepository;
import com.bizunited.nebula.venus.service.local.service.images.ImageHandler;
import com.bizunited.nebula.venus.service.local.service.images.ImageHandlerBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class ImageHandleServiceImpl
implements ImageHandleService {
    private static final Log LOGGER = LogFactory.getLog(ImageHandleServiceImpl.class);
    private static final String MESS_CUT_IMAGE = "cutimage";
    private static final String MESS_ZOOM_IMAGE = "zoomimage";
    @Autowired
    private OrdinaryFileRepository ordinaryFileRepository;
    @Autowired
    private FileHandleService fileHandleService;
    @Autowired
    private VenusFileEventListener venusFileEventListener;

    @Transactional
    public List<OrdinaryFileVo> imageUpload(String subsystem, String creator, Integer effective, MultipartFile[] files) {
        Validate.notNull((Object)(files != null && files.length > 0 ? 1 : 0), (String)"\u4e0a\u4f20\u7684\u56fe\u7247\u6587\u4ef6\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)creator, (String)"\u56fe\u7247\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (MultipartFile file : files) {
            String originalFilename = file.getOriginalFilename();
            String prefix = null;
            int prefixIndex = originalFilename.lastIndexOf(46);
            if (prefixIndex == -1) continue;
            prefix = originalFilename.substring(prefixIndex + 1);
            prefix = prefix.toLowerCase();
        }
        return this.fileHandleService.fileUpload(subsystem, creator, effective, files);
    }

    public List<OrdinaryFileVo> imageUpload(String subsystem, String creator, Integer effective, String[] fileNanmes, String[] base64Contents) {
        Validate.notBlank((CharSequence)creator, (String)"\u56fe\u7247\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (base64Contents == null || base64Contents.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684base64\u7f16\u7801\u6587\u4ef6\u5185\u5bb9!!");
        }
        if (fileNanmes == null || fileNanmes.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u6587\u4ef6\u540d\u6570\u91cf\u4fe1\u606f!!");
        }
        Validate.isTrue((fileNanmes.length == base64Contents.length ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5185\u5bb9\u6570\u91cf\u548c\u6587\u4ef6\u540d\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (int index = 0; index < fileNanmes.length; ++index) {
            String originalFilename = fileNanmes[index];
            String prefix = null;
            int prefixIndex = originalFilename.lastIndexOf(46);
            if (prefixIndex == -1) continue;
            prefix = originalFilename.substring(prefixIndex + 1);
            prefix = prefix.toLowerCase();
        }
        return this.fileHandleService.fileUpload(subsystem, creator, effective, fileNanmes, base64Contents);
    }

    public byte[] imageQuery(String relativeLocal, String fileName) throws IOException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{relativeLocal, fileName})) {
            return new byte[0];
        }
        OrdinaryFileEntity ordinaryFile = this.ordinaryFileRepository.findByFileNameAndRelativeLocalAndTenantCode(fileName, relativeLocal, TenantUtils.getTenantCode());
        if (ordinaryFile == null) {
            return new byte[0];
        }
        String prefix = ordinaryFile.getPrefix();
        String originalFileName = ordinaryFile.getOriginalFileName();
        return this.fileContentsQuery(relativeLocal, originalFileName, fileName, "", prefix);
    }

    private byte[] fileContentsQuery(String relativeLocal, String fileName, String fileRename, String special, String prefix) throws IOException {
        byte[] fileBytes = this.venusFileEventListener.onReadFileContent(relativeLocal, fileRename);
        if (fileBytes == null) {
            return new byte[0];
        }
        if (StringUtils.isBlank((CharSequence)special) || !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"jpeg") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"jpg") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"gif") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"bmp") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"png")) {
            return fileBytes;
        }
        String[] specialSteps = special.split("\\-\\>");
        if (specialSteps.length == 0) {
            return fileBytes;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(fileBytes));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        ImageHandlerBuilder.Builder builder = new ImageHandlerBuilder.Builder();
        for (String specialStep : specialSteps) {
            String[] params = specialStep.split("\\|");
            if (StringUtils.equals((CharSequence)params[0], (CharSequence)MESS_CUT_IMAGE)) {
                this.builderCutAndZoomImageHandle(params, builder, MESS_CUT_IMAGE);
                continue;
            }
            if (StringUtils.equals((CharSequence)params[0], (CharSequence)MESS_ZOOM_IMAGE)) {
                this.builderCutAndZoomImageHandle(params, builder, MESS_ZOOM_IMAGE);
                continue;
            }
            if (!StringUtils.equals((CharSequence)params[0], (CharSequence)"markimage")) continue;
            this.builderMarkImageHandle(params, builder);
        }
        ImageHandler imageHandle = builder.build();
        BufferedImage imageResults = imageHandle.dispose(bufferedImage);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imageResults, prefix, out);
        return out.toByteArray();
    }

    public byte[] imageQuery(String folder, String imageFile, String prefix, String special) throws IOException {
        String relativePath = folder;
        String fileName = imageFile + "." + prefix;
        return this.fileContentsQuery(relativePath, fileName, fileName, special, prefix);
    }

    private void builderMarkImageHandle(String[] params, ImageHandlerBuilder.Builder builder) {
        String markValue = null;
        Integer fontSize = 20;
        for (String param : params) {
            String[] paramVars = param.split("=");
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"markValue")) {
                markValue = paramVars[1];
            }
            if (!StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"fontSize")) continue;
            fontSize = Integer.parseInt(paramVars[1]);
        }
        if (StringUtils.isEmpty(markValue)) {
            throw new IllegalArgumentException("markValue must be set value!");
        }
        builder.createMarkHandler(markValue, fontSize);
    }

    private void builderCutAndZoomImageHandle(String[] params, ImageHandlerBuilder.Builder builder, String opType) {
        Integer width = null;
        Integer height = null;
        Float ratio = null;
        for (String param : params) {
            String[] paramVars = param.split("=");
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"width")) {
                width = Integer.parseInt(paramVars[1]);
                continue;
            }
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"height")) {
                height = Integer.parseInt(paramVars[1]);
                continue;
            }
            if (!StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"ratio")) continue;
            ratio = Float.valueOf(Float.parseFloat(paramVars[1]));
        }
        if (ratio != null && (ratio.floatValue() <= 0.0f || ratio.floatValue() >= 1.0f)) {
            throw new IllegalArgumentException("ratio must between from 0 to 1!");
        }
        if (ratio == null && (width == null || height == null)) {
            throw new IllegalArgumentException("width and height must be set value!");
        }
        if (ratio != null && StringUtils.equals((CharSequence)opType, (CharSequence)MESS_CUT_IMAGE)) {
            builder.createCutHandler(ratio.floatValue());
        } else if (ratio != null && StringUtils.equals((CharSequence)opType, (CharSequence)MESS_ZOOM_IMAGE)) {
            builder.createZoomHandler(ratio.floatValue());
        } else if (ratio == null && StringUtils.equals((CharSequence)opType, (CharSequence)MESS_CUT_IMAGE)) {
            builder.createCutHandler(width, height);
        } else if (ratio == null && StringUtils.equals((CharSequence)opType, (CharSequence)MESS_ZOOM_IMAGE)) {
            builder.createZoomHandler(width, height);
        }
    }
}

