package com.bizunited.nebula.venus.service.local.config;

import javax.servlet.MultipartConfigElement;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.util.unit.DataSize;

import com.bizunited.nebula.venus.sdk.config.SimpleVenusProperties;
import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.bizunited.nebula.venus.sdk.service.document.DocumentService;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.service.file.FileRelativeTemplate;
import com.bizunited.nebula.venus.sdk.service.image.ImageHandleService;
import com.bizunited.nebula.venus.service.local.service.internal.DefaultFileRelativeTemplate;
import com.bizunited.nebula.venus.service.local.service.internal.DocumentServiceImpl;
import com.bizunited.nebula.venus.service.local.service.internal.FileHandleServiceImpl;
import com.bizunited.nebula.venus.service.local.service.internal.ImageHandleServiceImpl;
import com.bizunited.nebula.venus.service.local.service.notifier.VenusFileEventListenerImpl;

/**
 * 文件服务中心的本地实现自动化配置
 * @Author: Paul Chan
 * @Date: 2020-03-16 10:14
 */
@Configuration
@EntityScan(basePackages = "com.bizunited.nebula.venus.service.local.entity")
@EnableJpaRepositories(basePackages = "com.bizunited.nebula.venus.service.local.repository")
@ComponentScan(basePackages = {"com.bizunited.nebula.venus"})
@EnableElasticsearchRepositories(basePackages = "com.bizunited.nebula.venus.service.local.elasticsearch.repository")
public class VenusLocalServiceAutoConfiguration {
  @Autowired
  private SimpleVenusProperties venusProperties;
  
  @Bean
  @ConditionalOnMissingBean
  public FileRelativeTemplate getLocalFileRelativeTemplate() {
    return new DefaultFileRelativeTemplate();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public DocumentService getDocumentService() {
    return new DocumentServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public ImageHandleService getFileViewService() {
    return new ImageHandleServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public FileHandleService getFileUpdateService() {
    return new FileHandleServiceImpl();
  }
  
  /**
   * 这是一个默认的本地实现——本地块存储
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public VenusFileEventListener getVenusFileEventListener() {
    return new VenusFileEventListenerImpl();
  }
  
  /**
   * 文件上传配置
   * */
  @Bean
  public MultipartConfigElement multipartConfigElement() {
    MultipartConfigFactory factory = new MultipartConfigFactory();
    // 单个文件最大
    factory.setMaxFileSize(DataSize.ofMegabytes(venusProperties.getMaxFileSize().longValue()));
    // 设置总上传数据总大小
    factory.setMaxRequestSize(DataSize.ofMegabytes(venusProperties.getMaxFileSize() * 5l));
    return factory.createMultipartConfig();
  }
}