package com.bizunited.nebula.venus.service.local.elasticsearch.repository.internal;

import com.bizunited.nebula.venus.sdk.constant.Constants;
import com.bizunited.nebula.venus.service.local.entity.DocumentEntity;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.stereotype.Repository;
import java.util.List;

/**
 * 文档自定义持久化实现
 * @Author: zengxingwang
 * @Date: 2020/4/13 11:38
 */
@Repository("DocumentEsRepositoryImpl")
public class DocumentEsRepositoryImpl implements DocumentEsRepositoryCustom {

  @Autowired
  private AbstractElasticsearchTemplate elasticsearchTemplate;

  /**
   * 根据关键字查询文档，支持模糊
   * @return
   */
  @Override
  public List<DocumentEntity> findByKeyword(String keyword) {
    BoolQueryBuilder builder = QueryBuilders.boolQuery();
    if(StringUtils.isNotBlank(keyword)) {
      String parserParam = StringUtils.join("*", keyword, "*");
      BoolQueryBuilder paramBuilder = QueryBuilders.boolQuery();
      paramBuilder.should(QueryBuilders.wildcardQuery("title.keyword", parserParam));
      paramBuilder.should(QueryBuilders.wildcardQuery("content.keyword", parserParam));
      builder.must(paramBuilder);
    }
    NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
    queryBuilder.withQuery(builder);
    Pageable pageable = PageRequest.of(0, Constants.ES_SEARCH_MAX_ROW);
    queryBuilder.withPageable(pageable);
    NativeSearchQuery query = queryBuilder.build();
    
    return elasticsearchTemplate.multiGet(query, DocumentEntity.class , IndexCoordinates.of(keyword));
  }
}
