package com.bizunited.nebula.venus.service.local.repository;


import com.bizunited.nebula.venus.service.local.entity.DocumentEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * 文档的数据层服务
 * @author: pangdajin
 * @date: 2020-04-07 16:46
 **/
@Repository("DocumentRepository")
public interface DocumentRepository
    extends JpaRepository<DocumentEntity, String>, JpaSpecificationExecutor<DocumentEntity> {
  /**
   * 查询标题树根
   * @return
   */

  @Query(value = "from DocumentEntity doc where doc.parent = null order by doc.sort")
  Set<DocumentEntity> findByNullParent();

  /**
   * 查询没有parentId时title的数量
   * @param title
   * @return
   */
  @Query(value = "select count(*) from DocumentEntity doc where doc.title = :title and doc.parent = null ")
  long countByNullParentAndTitle(@Param("title") String titlee);

  /**
   * 查询title的文档
   * @param title
   * @return
   */
  @Query(value = "select doc from DocumentEntity doc where doc.title = :title and doc.parent = null")
  DocumentEntity findByNullParentAndTitle(@Param("title") String title);

  /**
   * 查询有相同parentId时title的数量
   * @param title
   * @return
   */
  @Query(value = "select count(*) from DocumentEntity  doc inner join doc.parent pdoc where pdoc.id = :parentId and doc.title = :title ")
  long countByParentAndTitle(@Param("title") String title, @Param("parentId") String parentId);

  /**
   * 根据父级和标题查询文档
   * @param title
   * @return
   */
  @Query(value = "select doc from DocumentEntity  doc inner join doc.parent pdoc where pdoc.id = :parentId and doc.title = :title  ")
  DocumentEntity findByParentAndTitle(@Param("title") String title, @Param("parentId") String parentId);

  /**
   * 根据父级查询文档
   * @param id
   * @return
   */
  @Query(value = "select doc from DocumentEntity  doc inner join doc.parent pdoc where pdoc.id = :id order by doc.sort")
  List<DocumentEntity> findByParent(@Param("id") String id);
}
