package com.bizunited.nebula.venus.service.local.repository;

import com.bizunited.nebula.venus.service.local.entity.OrdinaryFileEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * 文件附件使用的数据层服务
 * @author yinwenjie
 */
@Repository("OrdinaryFileRepository")
public interface OrdinaryFileRepository
    extends
    JpaRepository<OrdinaryFileEntity, String>,
    JpaSpecificationExecutor<OrdinaryFileEntity> {
  /**
      * 获取时间点之前的普通文件数据
   * @param createDate 时间点
   * @return 查询到的OrdinaryFileEntity集合
   */
  List<OrdinaryFileEntity> findByCreateTimeBeforeAndTenantCodeOrderByCreateTimeAsc(Date createTime , String tenantCode);
  
  /**
   * 按照文件名和相对路径，查询文件描述信息
   * @param fileName 重命名后的文件名
   * @param relativeLocal 文件保存的路径
   * @return
   */
  OrdinaryFileEntity findByFileNameAndRelativeLocalAndTenantCode(String fileName, String relativeLocal , String tenantCode);
  
  /**
   * 删除指定的文件编号对应的数据库信息
   * @param fileId
   */
  @Modifying
  @Query(value = "delete from engine_file where id = :fileId" , nativeQuery = true)
  void deleteById(@Param("fileId") String fileId);
  
  /**
   * 按照当前指定的时间点，查询文件有效时间小于这个时间点所有文件信息
   * @param currentDate 当前指定的时间点
   * @return 
   */
  @Query("from OrdinaryFileEntity ofe where ofe.effectiveDate < :currentDate and tenantCode= :tenantCode")
  List<OrdinaryFileEntity> findByEffectiveDateAndTenantCode(@Param("currentDate") Date currentDate , @Param("tenantCode") String tenantCode);
}