/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.config;

import com.bizunited.nebula.venus.sdk.config.SimpleVenusProperties;
import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.service.file.FileRelativeTemplate;
import com.bizunited.nebula.venus.sdk.service.image.ImageHandleService;
import com.bizunited.nebula.venus.service.local.service.async.FileAsyncHandler;
import com.bizunited.nebula.venus.service.local.service.internal.DefaultFileRelativeTemplate;
import com.bizunited.nebula.venus.service.local.service.internal.FileHandleServiceImpl;
import com.bizunited.nebula.venus.service.local.service.internal.ImageHandleServiceImpl;
import com.bizunited.nebula.venus.service.local.service.notifier.VenusFileEventListenerImpl;
import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.util.unit.DataSize;

@Configuration
@EntityScan(basePackages={"com.bizunited.nebula.venus.service.local.entity"})
@EnableJpaRepositories(basePackages={"com.bizunited.nebula.venus.service.local.repository"})
@ComponentScan(basePackages={"com.bizunited.nebula.venus"})
public class VenusLocalServiceAutoConfiguration {
    @Autowired
    private SimpleVenusProperties venusProperties;

    @Bean
    @ConditionalOnMissingBean
    public FileRelativeTemplate getLocalFileRelativeTemplate() {
        return new DefaultFileRelativeTemplate();
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageHandleService getFileViewService() {
        return new ImageHandleServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public FileHandleService getFileUpdateService() {
        return new FileHandleServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public VenusFileEventListener getVenusFileEventListener() {
        return new VenusFileEventListenerImpl();
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.ofMegabytes((long)this.venusProperties.getMaxFileSize().longValue()));
        factory.setMaxRequestSize(DataSize.ofMegabytes((long)((long)this.venusProperties.getMaxFileSize().intValue() * 5L)));
        return factory.createMultipartConfig();
    }

    @Bean
    @Scope(value="prototype")
    public FileAsyncHandler getAsyncHandleThread(String tenantCode, String relativePath, String originalFilename, String fileRename, byte[] fileContext) {
        return new FileAsyncHandler(tenantCode, relativePath, originalFilename, fileRename, fileContext);
    }
}

