/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.async;

import com.bizunited.nebula.common.service.async.AsyncTaskRunnable;
import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.bizunited.nebula.venus.service.local.entity.OrdinaryFileEntity;
import com.bizunited.nebula.venus.service.local.repository.OrdinaryFileRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FileAsyncHandler
implements AsyncTaskRunnable<String> {
    private String tenantCode;
    private String relativePath;
    private String originalFilename;
    private String fileRename;
    private byte[] fileContext;
    @Autowired
    private VenusFileEventListener venusFileEventListener;
    @Autowired
    private OrdinaryFileRepository ordinaryFileRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAsyncHandler.class);

    public FileAsyncHandler(String tenantCode, String relativePath, String originalFilename, String fileRename, byte[] fileContext) {
        this.tenantCode = tenantCode;
        this.relativePath = relativePath;
        this.originalFilename = originalFilename;
        this.fileRename = fileRename;
        this.fileContext = fileContext;
    }

    public String run() {
        this.venusFileEventListener.onSaveFile(this.relativePath, this.originalFilename, this.fileRename, this.fileContext);
        return "";
    }

    public void error(Throwable throwable) {
        LOGGER.error(throwable.getMessage(), throwable);
        OrdinaryFileEntity currentOrdinaryFile = this.ordinaryFileRepository.findByFileNameAndRelativeLocalAndTenantCode(this.fileRename, this.relativePath, this.tenantCode);
        if (currentOrdinaryFile != null) {
            this.ordinaryFileRepository.deleteById(currentOrdinaryFile.getId());
        }
    }

    public void success(String result) {
    }
}

