/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.images;

import com.bizunited.nebula.venus.service.local.service.images.ImageHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class MarkStringImageHandler
extends ImageHandler {
    private String markValue;
    private int fontSize = 20;

    public MarkStringImageHandler(ImageHandler nextHandler, String markValue, int fontSize) {
        super(nextHandler);
        this.markValue = markValue;
        this.fontSize = fontSize;
    }

    @Override
    public BufferedImage dispose(BufferedImage srcImage) {
        Graphics graphics = srcImage.getGraphics();
        String[] markValueLines = this.markValue.split("<br>");
        int height = srcImage.getHeight();
        int mongoliaImageWidth = srcImage.getWidth();
        int mongoliaImageHeight = markValueLines.length * (this.fontSize + 2);
        BufferedImage mongoliaImage = new BufferedImage(mongoliaImageWidth, height, 2);
        for (int withIndex = 0; withIndex < mongoliaImageWidth; ++withIndex) {
            int heightIndex = height - mongoliaImageHeight;
            int n = heightIndex = heightIndex < 0 ? 0 : heightIndex;
            while (heightIndex < height) {
                mongoliaImage.getAlphaRaster().setPixel(withIndex, heightIndex, new int[]{100, 20, 20, 20});
                ++heightIndex;
            }
        }
        Graphics2D mongoliaGraphics = mongoliaImage.createGraphics();
        mongoliaGraphics.setFont(new Font(null, 1, this.fontSize));
        mongoliaGraphics.setColor(new Color(255, 255, 255));
        int stringIndex = 0;
        for (int index = markValueLines.length - 1; index >= 0; --index) {
            int y = height - (this.fontSize * index + 1);
            y = y < 0 ? 0 : y;
            ((Graphics)mongoliaGraphics).drawString(" " + markValueLines[stringIndex++], 0, y);
        }
        graphics.drawImage(mongoliaImage, 0, 0, null);
        graphics.dispose();
        BufferedImage nextResults = this.doNextHandler(srcImage);
        if (nextResults == null) {
            return srcImage;
        }
        return nextResults;
    }
}

