/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.venus.sdk.service.PhotoWallDocumentService;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.PhotoWallDocumentDto;
import com.bizunited.nebula.venus.service.local.entity.PhotoWallDocumentStructureEntity;
import com.bizunited.nebula.venus.service.local.entity.PhotoWallDocumentStructureFieldEntity;
import com.bizunited.nebula.venus.service.local.repository.PhotoWallDocumentStructureRepository;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PhotoWallDocumentServiceImpl
implements PhotoWallDocumentService {
    @Autowired
    private FileHandleService fileHandleService;
    @Autowired
    private RestHighLevelClient highRestClient;
    @Autowired
    private PhotoWallDocumentStructureRepository photoWallDocumentStructureRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotoWallDocumentServiceImpl.class);

    public void up(String[] fileCodes, String code, JSONObject form) {
        this.up(fileCodes, code, form, false);
    }

    private void up(String[] fileCodes, String code, JSONObject form, boolean rebuild) {
        Date modifyTime;
        Validate.notBlank((CharSequence)code, (String)"\u7167\u7247\u4e0a\u5899\u64cd\u4f5c\u5fc5\u987b\u6307\u5b9a\u7167\u7247\u5899\u7c7b\u578bcode\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)form, (String)"\u7167\u7247\u4e0a\u5899\u64cd\u4f5c\u5fc5\u987b\u6307\u5b9a\u7167\u7247\u63cf\u8ff0\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String billCode = form.getString("billCode");
        Validate.notBlank((CharSequence)billCode, (String)"\u7167\u7247\u4e0a\u5899\u64cd\u4f5c\u5fc5\u987b\u6307\u5b9a\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((fileCodes != null && fileCodes.length > 0 ? 1 : 0) != 0, (String)"\u7167\u7247\u4e0a\u5899\u64cd\u4f5c\u5fc5\u987b\u6307\u5b9a\u81f3\u5c11\u4e00\u4e2a\u7167\u7247\u9644\u4ef6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (String fileCode : fileCodes) {
            Validate.notNull((Object)this.fileHandleService.findById(fileCode), (String)"\u7167\u7247\u4e0a\u5899\u64cd\u4f5c\u5173\u8054\u7684\u7167\u7247\u9644\u4ef6\u3010%s\u3011\u4fe1\u606f\u5fc5\u987b\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{fileCode});
        }
        PhotoWallDocumentStructureEntity photoWallDocumentStructure = this.photoWallDocumentStructureRepository.findDetailsByCode(code);
        Validate.notNull((Object)((Object)photoWallDocumentStructure), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7167\u7247\u5899\u7c7b\u578b\u6587\u6863\u7ed3\u6784\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code});
        List<PhotoWallDocumentStructureFieldEntity> structureFields = photoWallDocumentStructure.getPhotoWallDocumentStructureFields();
        Validate.isTrue((!CollectionUtils.isEmpty(structureFields) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7167\u7247\u5899\u7c7b\u578b\u6587\u6863\u7ed3\u6784\u4e0b\u7684\u4efb\u4f55\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String createAccount = form.getString("createAccount");
        Validate.notBlank((CharSequence)createAccount, (String)"\u672a\u53d1\u73b0\u7167\u7247\u6587\u6863\u7684\u521b\u5efa\u8005\u4fe1\u606f", (Object[])new Object[0]);
        String modifyAccount = form.getString("modifyAccount");
        Validate.notBlank((CharSequence)modifyAccount, (String)"\u672a\u53d1\u73b0\u7167\u7247\u6587\u6863\u7684\u4fee\u6539\u8005\u4fe1\u606f", (Object[])new Object[0]);
        Date now = new Date();
        Date createTime = form.getDate("createTime");
        if (createTime == null) {
            form.put("createTime", (Object)now);
        }
        if ((modifyTime = form.getDate("modifyTime")) == null) {
            form.put("modifyTime", (Object)now);
        }
        if (rebuild) {
            this.dismiss(code, billCode);
        }
        for (String fileCode : fileCodes) {
            form.put("fileCode", (Object)fileCode);
            String index = StringUtils.join((Object[])new String[]{"photo_wall_es_prefix_", StringUtils.lowerCase((String)code)});
            String id = UUID.randomUUID().toString();
            IndexRequest indexRequest = new IndexRequest(index).id(id).source((Map)form, XContentType.JSON);
            try {
                IndexResponse response = this.highRestClient.index(indexRequest, RequestOptions.DEFAULT);
                if (response.status() == RestStatus.CREATED) continue;
                LOGGER.error(response.toString());
                throw new IllegalArgumentException("\u66f4\u65b0\u7167\u7247\u5899\u6587\u6863\u65f6\uff0c\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01\uff01");
            }
            catch (IOException | RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }

    public void reUp(String[] fileCodes, String code, JSONObject form) {
        this.up(fileCodes, code, form, true);
    }

    public void dismiss(String code, String billCode) {
        Validate.notBlank((CharSequence)billCode, (String)"\u8fdb\u884c\u7167\u7247\u5899\u4fe1\u606f\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u4f20\u9012\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f!", (Object[])new Object[0]);
        String index = StringUtils.join((Object[])new String[]{"photo_wall_es_prefix_", StringUtils.lowerCase((String)code)});
        try {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{index});
            MatchQueryBuilder queryBuilder = new MatchQueryBuilder("billCode", (Object)billCode);
            deleteByQueryRequest.setQuery((QueryBuilder)queryBuilder);
            BulkByScrollResponse response = this.highRestClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            LOGGER.info("\u57fa\u4e8e\u4e1a\u52a1\u7f16\u53f7{} \u8fdb\u884c\u539f\u6709\u7167\u7247\u9644\u4ef6\u7684\u5220\u9664\u64cd\u4f5c\uff0c\u88ab\u5220\u9664\u7684\u6570\u91cf\u4e3a\uff1a{}", (Object)billCode, (Object)response.getDeleted());
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Page<?> findByConditions(Pageable pageable, PhotoWallDocumentDto condition) {
        String code;
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code = condition.getCode()})) {
            return null;
        }
        PhotoWallDocumentStructureEntity photoWallDocumentStructure = this.photoWallDocumentStructureRepository.findDetailsByCode(code);
        if (photoWallDocumentStructure == null) {
            return null;
        }
        List<PhotoWallDocumentStructureFieldEntity> structureFields = photoWallDocumentStructure.getPhotoWallDocumentStructureFields();
        if (CollectionUtils.isEmpty(structureFields)) {
            return null;
        }
        String index = StringUtils.join((Object[])new String[]{"photo_wall_es_prefix_", StringUtils.lowerCase((String)code)});
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        String tenantCode = condition.getTenantCode();
        LOGGER.debug("tenantCode = " + tenantCode);
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)tenantCode).field("tenantCode"));
        }
        if (condition.getCreateTimeStart() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createTime").gte((Object)condition.getCreateTimeStart()));
        }
        if (condition.getCreateTimeEnd() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createTime").lte((Object)condition.getCreateTimeEnd()));
        }
        if (condition.getModifyTimeStart() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"modifyTime").gte((Object)condition.getModifyTimeStart()));
        }
        if (condition.getModifyTimeEnd() != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"modifyTime").lte((Object)condition.getModifyTimeEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getCreateAccount())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)condition.getCreateAccount()).field("createAccount"));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getModifyAccount())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)condition.getModifyAccount()).field("modifyAccount"));
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getBillCode())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"billCode", (Object)condition.getBillCode()));
        }
        List<String> structureAnalyzerFieldCodes = structureFields.stream().filter(item -> item.getAnalyzer() != null && item.getAnalyzer() != false).map(PhotoWallDocumentStructureFieldEntity::getFieldCode).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)condition.getContent()) && !CollectionUtils.isEmpty(structureAnalyzerFieldCodes)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)condition.getContent(), (String[])structureAnalyzerFieldCodes.toArray(new String[0])));
        }
        int from = pageable.getPageNumber() * pageable.getPageSize();
        searchSourceBuilder.from(from);
        searchSourceBuilder.size(pageable.getPageSize());
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("createTime", SortOrder.DESC);
        searchRequest.source(searchSourceBuilder);
        SearchHits searchHits = null;
        Object[] hits = null;
        try {
            SearchResponse searchResponse = this.highRestClient.search(searchRequest, RequestOptions.DEFAULT);
            searchHits = searchResponse.getHits();
            if (searchHits == null) {
                return null;
            }
            hits = searchHits.getHits();
            if (hits == null || hits.length == 0) {
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        long totalHits = searchHits.getTotalHits().value;
        PageImpl pageResult = new PageImpl((List)Lists.newArrayList((Object[])hits), pageable, totalHits);
        return pageResult;
    }
}

