/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.venus.sdk.service.PhotoWallRegisterService;
import com.bizunited.nebula.venus.sdk.vo.PhotoWallDocumentStructureFieldVo;
import com.bizunited.nebula.venus.sdk.vo.PhotoWallDocumentStructureVo;
import com.bizunited.nebula.venus.service.local.entity.PhotoWallDocumentStructureEntity;
import com.bizunited.nebula.venus.service.local.entity.PhotoWallDocumentStructureFieldEntity;
import com.bizunited.nebula.venus.service.local.repository.PhotoWallDocumentStructureFieldRepository;
import com.bizunited.nebula.venus.service.local.repository.PhotoWallDocumentStructureRepository;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PhotoWallRegisterServiceImpl
implements PhotoWallRegisterService {
    @Autowired
    private RestHighLevelClient highRestClient;
    @Autowired
    private PhotoWallDocumentStructureRepository photoWallDocumentStructureRepository;
    @Autowired
    private PhotoWallDocumentStructureFieldRepository photoWallDocumentStructureFieldRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotoWallRegisterServiceImpl.class);

    @Transactional
    public void saveIndex(PhotoWallDocumentStructureVo photoWallDocumentStructure) {
        Validate.notNull((Object)photoWallDocumentStructure, (String)"\u7167\u7247\u5899\u7c7b\u578b\u7ed3\u6784\u4e0d\u80fd\u4e3anull\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String code = photoWallDocumentStructure.getCode();
        String name = photoWallDocumentStructure.getName();
        Validate.notBlank((CharSequence)code, (String)"\u7167\u7247\u5899\u7c7b\u578bcode\uff08\u7f16\u53f7\uff09\uff0c\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)name, (String)"\u7167\u7247\u5899\u7c7b\u578bname\uff08\u540d\u79f0\uff09\uff0c\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String index = StringUtils.join((Object[])new String[]{"photo_wall_es_prefix_", StringUtils.lowerCase((String)code)});
        if (!this.redisMutexService.tryLock(index, TimeUnit.SECONDS, 10)) {
            return;
        }
        try {
            this.saveIndex(photoWallDocumentStructure, index);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.redisMutexService.unlock(index);
        }
    }

    private void saveIndex(PhotoWallDocumentStructureVo photoWallDocumentStructure, String index) {
        IndicesClient indicesClient = this.highRestClient.indices();
        String code = photoWallDocumentStructure.getCode();
        String name = photoWallDocumentStructure.getName();
        List photoWallDocumentStructureFields = photoWallDocumentStructure.getPhotoWallDocumentStructureFields();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)photoWallDocumentStructureFields) ? 1 : 0) != 0, (String)"\u7167\u7247\u5899\u7c7b\u578b\u5bf9\u5e94\u7684\u8868\u5355\u5b57\u6bb5\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        long distinctCount = photoWallDocumentStructureFields.stream().map(PhotoWallDocumentStructureFieldVo::getFieldCode).filter(value -> StringUtils.isNotBlank((CharSequence)value)).distinct().count();
        Validate.isTrue(((long)photoWallDocumentStructureFields.size() == distinctCount ? 1 : 0) != 0, (String)"\u7167\u7247\u5899\u7ed3\u6784\u5206\u6790\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u7ec4\u5b57\u6bb5\u7684\u5b57\u6bb5\u540d\u91cd\u590d\u6216\u8005\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (PhotoWallDocumentStructureFieldVo photoWallDocumentStructureFieldVo : photoWallDocumentStructureFields) {
            String esFieldType = photoWallDocumentStructureFieldVo.getEsFieldType();
            Validate.notBlank((CharSequence)esFieldType, (String)"\u7167\u7247\u5899\u7ed3\u6784\u5206\u6790\u65f6\uff0c\u81f3\u5c11\u53d1\u73b0\u4e00\u4e2a\u5b57\u6bb5\u4fe1\u606f\u7684ES\u7c7b\u578b\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            String fieldName = photoWallDocumentStructureFieldVo.getFieldName();
            Validate.notBlank((CharSequence)fieldName, (String)"\u7167\u7247\u5899\u7ed3\u6784\u5206\u6790\u65f6\uff0c\u81f3\u5c11\u53d1\u73b0\u4e00\u4e2a\u5b57\u6bb5\u4fe1\u606f\u7684\u4e2d\u6587\u4fe1\u606f\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            String fieldClass = photoWallDocumentStructureFieldVo.getFieldClass();
            Validate.notBlank((CharSequence)fieldClass, (String)"\u7167\u7247\u5899\u7ed3\u6784\u5206\u6790\u65f6\uff0c\u81f3\u5c11\u53d1\u73b0\u4e00\u4e2a\u5b57\u6bb5\u4fe1\u606f\u7684\u8fd0\u884c\u7c7b\u578b\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            try {
                Class.forName(fieldClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("\u7167\u7247\u5899\u7ed3\u6784\u5206\u6790\u65f6\uff0c\u81f3\u5c11\u53d1\u73b0\u4e00\u4e2a\u5b57\u6bb5\u4fe1\u606f\u7684\u8fd0\u884c\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fdd\u8bc1\u6240\u6709\u5b57\u6bb5\u5747\u662f\u7b80\u5355\u7c7b\u578b!!");
            }
        }
        GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{index});
        boolean exist = false;
        try {
            exist = indicesClient.exists(getIndexRequest, RequestOptions.DEFAULT);
            if (!exist) {
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
                indicesClient.create(createIndexRequest, RequestOptions.DEFAULT);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        PhotoWallDocumentStructureEntity photoWallDocumentStructureEntity = this.photoWallDocumentStructureRepository.findDetailsByCode(code);
        if (photoWallDocumentStructureEntity != null) {
            this.photoWallDocumentStructureFieldRepository.deleteByDocumentStructure(photoWallDocumentStructureEntity.getId());
            this.photoWallDocumentStructureRepository.delete((Object)photoWallDocumentStructureEntity);
            this.photoWallDocumentStructureRepository.flush();
        }
        String account = "admin";
        Date now = new Date();
        photoWallDocumentStructureEntity = new PhotoWallDocumentStructureEntity();
        photoWallDocumentStructureEntity.setCode(code);
        photoWallDocumentStructureEntity.setName(name);
        photoWallDocumentStructureEntity.setCreateAccount(account);
        photoWallDocumentStructureEntity.setCreateTime(now);
        photoWallDocumentStructureEntity.setModifyAccount(account);
        photoWallDocumentStructureEntity.setModifyTime(now);
        this.photoWallDocumentStructureRepository.save((Object)photoWallDocumentStructureEntity);
        Collection photoWallDocumentStructureFieldEnties = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)photoWallDocumentStructureFields, PhotoWallDocumentStructureFieldVo.class, PhotoWallDocumentStructureFieldEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        for (PhotoWallDocumentStructureFieldEntity photoWallDocumentStructureFieldEntity : photoWallDocumentStructureFieldEnties) {
            photoWallDocumentStructureFieldEntity.setDocumentStructure(photoWallDocumentStructureEntity);
            this.photoWallDocumentStructureFieldRepository.save((Object)photoWallDocumentStructureFieldEntity);
        }
    }

    public PhotoWallDocumentStructureVo findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        PhotoWallDocumentStructureEntity photoWallDocumentStructure = this.photoWallDocumentStructureRepository.findDetailsByCode(code);
        if (photoWallDocumentStructure == null) {
            return null;
        }
        return (PhotoWallDocumentStructureVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)photoWallDocumentStructure, PhotoWallDocumentStructureVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"photoWallDocumentStructureFields"});
    }

    public List<PhotoWallDocumentStructureVo> findAll() {
        List structures = this.photoWallDocumentStructureRepository.findAll(Sort.by((String[])new String[]{"code"}));
        if (CollectionUtils.isEmpty((Collection)structures)) {
            return null;
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)structures, PhotoWallDocumentStructureEntity.class, PhotoWallDocumentStructureVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }
}

