/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.scheduler;

import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CleanupScheduler {
    @Autowired
    private FileHandleService fileHandleService;
    @Autowired
    private VenusFileEventListener venusFileEventListener;
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanupScheduler.class);

    @Scheduled(cron="0 0 4 * * ?")
    public void cleanup() {
        Date currentDate = new Date();
        List ordinaryFiles = this.fileHandleService.findByEffectiveDate(currentDate);
        if (CollectionUtils.isEmpty((Collection)ordinaryFiles)) {
            return;
        }
        for (OrdinaryFileVo ordinaryFileVo : ordinaryFiles) {
            String relativePath = ordinaryFileVo.getRelativeLocal();
            String fileName = ordinaryFileVo.getFileName();
            String originalFileName = ordinaryFileVo.getOriginalFileName();
            try {
                this.fileHandleService.deleteFile(relativePath, fileName);
                this.venusFileEventListener.onDeleteFile(relativePath, originalFileName, fileName);
                LOGGER.info(" file {} deleted ", (Object)fileName);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }
}

