package com.bizunited.nebula.venus.sdk.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 默认的附件（含图片）管理模块实现中，关键配置信息
 * @author yinwenjie
 */
@Component
@ConfigurationProperties(prefix = "venus")
public class SimpleVenusProperties {
  /**
   * 保存文件的根路径描述（包括和图片设置的根目录重用）
   */
  private String fileRoot;
  /**
   * 最大允许的单个文件上传大小（单位MB）
   */
  private Integer maxFileSize = 10;
  /**
   * 文件有效期，默认为5年（1825天）, 单位天
   */
  private Integer effective = 1825;
  /**
   * 是否进行文件I/O操作的异步处理
   */
  private Boolean async = true;
  /**
   * 文件扩展名白名单
   */
  private String[] whitePrefixs;
  public Integer getMaxFileSize() {
    return maxFileSize;
  }
  public void setMaxFileSize(Integer maxFileSize) {
    this.maxFileSize = maxFileSize;
  }
  public String[] getWhitePrefixs() {
    return whitePrefixs;
  }
  public void setWhitePrefixs(String[] whitePrefixs) {
    this.whitePrefixs = whitePrefixs;
  }
  public String getFileRoot() {
    return fileRoot;
  }
  public void setFileRoot(String fileRoot) {
    this.fileRoot = fileRoot;
  }
  public Integer getEffective() {
    return effective;
  }
  public void setEffective(Integer effective) {
    this.effective = effective;
  }
  public Boolean getAsync() {
    return async;
  }
  public void setAsync(Boolean async) {
    this.async = async;
  }
}
