package com.bizunited.nebula.venus.sdk.service;

import org.springframework.data.domain.Page;

import org.springframework.data.domain.Pageable;

import com.alibaba.fastjson.JSONObject;

import com.bizunited.nebula.venus.sdk.vo.PhotoWallDocumentDto;

public interface PhotoWallDocumentService {
  /**
   * 上墙：将fileCodes对应图片附件，挂上照片墙。在form对象中存在业务单据号billCode；通过该方法上墙的照片内容将是当前业务单据号已关联上墙图片附件的累加；
   * @param fileCodes 指定的将上墙的图片附件code
   * @param code 照片墙类型code
   */
  public void up(String[] fileCodes , String code , JSONObject form);
  /**
   * 上墙：将fileCodes对应图片附件，挂上照片墙。在form对象中存在业务单据号billCode；通过该方法上墙的照片内容将不包括该单据号之前关联的图片附件内容；</br>
   * 也就是说之前上墙的，和指定业务单据关联的照片附件将会从照片墙上移除（但图片附件本身还是存在于venus中的）
   * @param fileCodes 指定的将上墙的图片附件code
   * @param code 照片墙类型code
   */
  public void reUp(String[] fileCodes , String code , JSONObject form);
  /**
   * 将指定的第三方单据所关联的图片附件从照片墙上移除
   * @param code 照片墙类型code
   * @param billCode
   */
  public void dismiss(String code ,String billCode);
  /**
   * 按照查询条件进行查询
   * @param pageable 
   * @param condition 查询条件中的code和tenantCode必须传入，否则不会返回任何信息
   * @return 
   */
  public Page<?> findByConditions(Pageable pageable , PhotoWallDocumentDto condition);
}
