package com.bizunited.nebula.venus.sdk.service;

import java.util.List;

import com.bizunited.nebula.venus.sdk.vo.PhotoWallDocumentStructureVo;

/**
 * 照片墙主要的逻辑在这个服务中进行体现
 * @author yinwenjie
 */
public interface PhotoWallRegisterService {
  
  /**
   * 这是共用的照片墙功能在ES中的索引前缀
   */
  public static final String PHOTO_WALL_ES_PREFIX = "photo_wall_es_prefix_";
  
  /**
   * 按照要求（最可能是venus客户端所在应用程序启动时的要求），检查并维护照片墙的文档结构(索引)
   * @param code 照片墙类型code
   * @param name 照片墙类型名称（中文描述）
   * @param documentStructure 照片墙类型对应的描述结构信息
   */
  public void saveIndex(PhotoWallDocumentStructureVo photoWallDocumentStructure);
  /**
   * 按照照片墙类型编号code，查询照片墙类型的文档结构
   * @param code 按照照片墙类型编号code
   * @return
   */
  public PhotoWallDocumentStructureVo findDetailsByCode(String code);
  /**
   * 查询当前已有的照片墙类型（按code进行排序，且只有基本信息）
   */
  public List<PhotoWallDocumentStructureVo> findAll();
}
