package com.bizunited.nebula.venus.sdk.service.file;

/**
 * 文件相对路径模版，作用于文件上传时对保存文件的相对路径的生成，
 * nebula系统提供一个默认的模版，业务系统可自行实现替换默认模版</p>
 * 
 * 这种场景一般是使用者不希望按照当前nebula/venus系统默认的使用日期 + 随机目录的方式
 * 生成和使用文件保存的相对路径，而希望使用一种自定义规则生成和使用文件保存目录的场景
 * 
 * @Author: Paul Chan yinwenjie
 * @Date: 2020-02-10 17:03
 */
public interface FileRelativeTemplate {
  /**
   * 生成相对路径
   * @param subSystem
   * @param originalFilename
   * @return
   */
  String generatRelativePath(String subSystem, String originalFilename);
}