package com.bizunited.nebula.venus.sdk.service.image;

import java.io.IOException;

public interface ImageHandleService {
  /**
   * 根据上传时返回的图片文件ID，查询图片内容——支持特效参数
   * @param id 文件在系统中的唯一id信息
   * @param special 指定的特效信息
   * @return
   * @throws IOException
   */
  public byte[] imageQueryById(String id , String special) throws IOException;
  /**
   * 通过文件相对路径查询指定的图片信息——支持特效参数
   * @param folder 图片所在目录
   * @param imageFile 图片名
   * @param prefix 图片后缀
   * @param special 指定的特效信息<br>
   * 这个方法测试有参数的图片访问方式<br/>
   * 这里留了几个测试参数：<br/>
   * ?special=zoomimage%7Cwidth%3D300%7Cheight%3D300->markimage%7CmarkValue%3Dwwwyinwenjienet.222<br/>
   * ?special=zoomimage%7Cratio%3D0.1->markimage%7CmarkValue%3Dwww.yinwenjie.net<br/>
   * ?special=cutimage%7Cratio%3D0.1->markimage%7CmarkValue%3Dwww.yinwenjie.net<br/>
   * ?special=cutimage%7Cwidth%3D300%7Cheight%3D300->markimage%7CmarkValue%3Dwww.yinwenjie.net<br/>
   * @throws IllegalArgumentException
   * @throws IOException
   */
  public byte[] imageQuery(String folder, String imageFile, String prefix, String special) throws IOException;

  /**
   * 直接查询指定文件的原图
   * @param relativeLocal 文件路径
   * @param fileName  文件名
   * @throws IOException
   */
  public byte[] imageQuery(String relativeLocal, String fileName) throws IOException;
}
