package com.bizunited.nebula.venus.sdk.vo;

import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Set;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 文档VO模型
 * @author: yinwenjie
 * @version 2.0
 **/
public class DocumentVo {
  
  @ApiModelProperty("技术层唯一技术编号")
  private String id;
  
  @ApiModelProperty("父级文档")
  private DocumentVo parent;
  
  @ApiModelProperty("标题")
  private String title;
  
  @ApiModelProperty("排序，升序排序")
  private Integer sort;

  @ApiModelProperty("创建人账号")
  private String creator;
  
  @ApiModelProperty("创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  
  @ApiModelProperty("更新人账号")
  private String modifier;
  
  @ApiModelProperty("最后更新时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  
  @ApiModelProperty("文档内容")
  private String content;
  
  @ApiModelProperty(name="relativeLocal" , value="文件在本地的存储目录（相对位置，不包括）" , required= false)
  private String relativeLocal;
  
  @ApiModelProperty(name="fileName" , value="重命名后的文件名字" , required=false)
  private String fileName;
  
  @ApiModelProperty("子级文档")
  private Set<DocumentVo> documents;
  
  @ApiModelProperty("当前项目名工程名")
  private String projectName;

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public DocumentVo getParent() {
    return parent;
  }

  public void setParent(DocumentVo parent) {
    this.parent = parent;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Integer getSort() {
    return sort;
  }

  public void setSort(Integer sort) {
    this.sort = sort;
  }

  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getModifier() {
    return modifier;
  }

  public void setModifier(String modifier) {
    this.modifier = modifier;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public String getRelativeLocal() {
    return relativeLocal;
  }

  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public Set<DocumentVo> getDocuments() {
    return documents;
  }

  public void setDocuments(Set<DocumentVo> documents) {
    this.documents = documents;
  }

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
}
