package com.bizunited.nebula.venus.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 普通文件附件、图片附件的记录信息
 * @author yinwenjie 
 */
@ApiModel(value = "OrdinaryFileVo" , description=" 普通文件附件、图片附件的记录信息")
public class OrdinaryFileVo {
  
  @ApiModelProperty("技术层唯一技术编号")
  private String id;
  /**
   * 文件的上传者
   */
  @ApiModelProperty(name="commitUser" , value="文件的上传者" , required=false)
  private String commitUser;
  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", value = "创建人账号", required = true)
  private String createAccount;
  /** 
   * 创建时间
   * */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /**
   * 更新人账号
   */
  @ApiModelProperty(name = "modifyAccount", value = "更新人账号", required = true)
  private String modifyAccount;
  /** 
   * 最后更新时间
   *  */
  @ApiModelProperty(name = "modifyTime", value = "最后更新时间", required = true)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /**
   * 重命名后的文件名字
   */
  @ApiModelProperty(name="fileName" , value="重命名后的文件名字" , required=false)
  private String fileName;
  /**
   * 重命名前的文件名字
   */
  @ApiModelProperty(name="originalFileName" , value="重命名前的文件名字" , required=false)
  private String originalFileName;
  /**
   * 文件在本地的存储目录（相对位置，不包括）<br>
   */
  @ApiModelProperty(name="relativeLocal" , value="文件在本地的存储目录（相对位置，不包括）" , required=false)
  private String relativeLocal;
  /**
   * 文件的扩展类型，例如：png、gif、jpg等
   */
  @ApiModelProperty(name="prefix" , value="文件的扩展类型，例如：png、gif、jpg等" , required=false)
  private String prefix;
  /**
   * 文件有效期截止，默认为3999-01-01 00:00:00
   */
  @ApiModelProperty(name="effectiveDate" , value="文件有效期截止" , required=false)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date effectiveDate;
  /**
   * 文件大小单位Byte（字节）
   */
  @ApiModelProperty(name="fileSize" , value="文件大小单位Byte（字节）" , required=false)
  private Long fileSize;
  /**
   * 当前租户信息
   */
  @ApiModelProperty("当前租户信息")
  private String tenantCode;
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getCommitUser() {
    return commitUser;
  }
  public void setCommitUser(String commitUser) {
    this.commitUser = commitUser;
  }
  public String getCreateAccount() {
    return createAccount;
  }
  public void setCreateAccount(String createAccount) {
    this.createAccount = createAccount;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public String getModifyAccount() {
    return modifyAccount;
  }
  public void setModifyAccount(String modifyAccount) {
    this.modifyAccount = modifyAccount;
  }
  public Date getModifyTime() {
    return modifyTime;
  }
  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public String getOriginalFileName() {
    return originalFileName;
  }
  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }
  public String getRelativeLocal() {
    return relativeLocal;
  }
  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }
  public String getPrefix() {
    return prefix;
  }
  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }
  public Date getEffectiveDate() {
    return effectiveDate;
  }
  public void setEffectiveDate(Date effectiveDate) {
    this.effectiveDate = effectiveDate;
  }
  public Long getFileSize() {
    return fileSize;
  }
  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }
  public String getTenantCode() {
    return tenantCode;
  }
  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
  
}
